unit uBafInterpreterModuleList;

// this code is under the BAF fair use license (BFUL) - https://bafbal.de/index.php?title=Bful
// List of Interpreter Moduls

interface

uses uBafInterpreter;

type
  TBafInterpreterModuleList = class
  protected
    class procedure CreateAndRegister(AName: string; AInter: TBafInterpreter;
        AClass: TBafInterpreterModuleClass);
  public
    class procedure CreateModule(AInter: TBafInterpreter);

  end;

implementation

uses uBafVarModule, uBafFrmModule, uBafDbModule
    , uBafPdfModule2
    , uBafTranslationModule
    , uBafWebModule
    , uBafXlsModule
    , uBafXmlModule
    , uBafJsonModule

;

var
  mvLastModule: TBafInterpreterCustomModule;


{ TInterModuleList }

class procedure TBafInterpreterModuleList.CreateAndRegister(AName: string;
    AInter: TBafInterpreter; AClass: TBafInterpreterModuleClass);
begin
  mvLastModule := AClass.Create;
  AInter.RegisterModule(AName, mvLastModule);
end;

class procedure TBafInterpreterModuleList.CreateModule(AInter: TBafInterpreter);
begin
  CreateAndRegister('var', AInter, TBafVarModule);   // the first module have to be the var module
  CreateAndRegister('db', AInter, TBafDbModule);
  CreateAndRegister('frm', AInter, TBafFrmModule);
  CreateAndRegister('trans', AInter, TBafTranslationModule);
  CreateAndRegister('xls', AInter, TBafXlsModule);
  CreateAndRegister('pdf', AInter, TBafPdfModule);
  CreateAndRegister('web', AInter, TBafWebModule);
  CreateAndRegister('xml', AInter, TBafXmlModule);
  CreateAndRegister('json', AInter, TBafJsonModule);
end;

end.


