unit uBafConsoleThread;

// this code is under the BAF fair use license (BFUL) - https://bafbal.de/index.php?title=Bful
// not used in the moment

interface

uses
  System.Classes, SysUtils, uBafInterpreter, uBafTypes;

type
  TBafConsoleThread = class(TThread)
  private
    FCommandLines: TStringList;
    FInter: TBafInterpreter;
    procedure CreateInter;
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean);
    destructor Destroy; override;
    property CommandLines: TStringList read FCommandLines;
  end;

implementation

var
  mvInter: integer;

{ TBafConsoleThread }

constructor TBafConsoleThread.Create(CreateSuspended: Boolean);
begin
  inherited Create(CreateSuspended);
  FCommandLines := TStringList.Create;
end;

procedure TBafConsoleThread.CreateInter;
begin
  inc(mvInter);
  FInter := TBafInterpreter.Create(itThread);
  FInter.Inter := FInter;
  FInter.Name := 'I' + IntToStr(mvInter);
//  FInter.OnNeedCommand := InterNeedCommand;
//  FInter.OnNeedInfo := InterNeedInfo;
//  FInter.OnLog := InterLog;
//  FInter.OnCaption := InterCaption;
//  FInter.ParentPanel := FPanelDesk;
//  FInter.OnDebugLog := InterDebugLog;
//  FInter.OnDebugNode := InterDebugNode;
//  FInter.OnClose := ButtonCloseClick;
//  TBafInterpreterModuleList.CreateModule(FInter);
end;

destructor TBafConsoleThread.Destroy;
begin
  FreeAndNil(FCommandLines);
  inherited;
end;

procedure TBafConsoleThread.Execute;
begin
  { Thread-Code hier einfgen }
end;

end.
