unit uBafAddDbModule;

interface

uses System.Math, System.SysUtils, System.Classes, uBafTypes, uBafInterpreter,
  System.Contnrs, IniFiles, Data.DB, System.StrUtils, uStringIniFile;

type

  TBafAddDbModule = class(TBafInterpreterCustomModule)
  protected
    procedure AdbExecSql(AIndex: integer);
    procedure AdbOpenSql(AIndex: integer);
    procedure AdbOpenSqlVal(AIndex: integer; AExecInter: TBafCustomInterpreter);
    procedure AdbOpenSqlValRows(AIndex: integer; AExecInter: TBafCustomInterpreter);
    function AdbGetData(AParams: TStrings): string;
  public
    constructor Create; override;
    destructor Destroy; override;
    function InterpretLine(AExecInter: TBafCustomInterpreter): boolean; override;
    function ReplaceFunction(ACommand: string; AParams: TStrings; var AResult: string): boolean; override;
  end;

implementation



{ TBafAddDbModule }

uses dmMain;

procedure TBafAddDbModule.AdbExecSql(AIndex: integer);
var
  LSql, LParam, LAddDb: string;
  LNum, LRows: integer;
begin
  LAddDb := FindParamStringReplaced('db', '');
  LSql := FInter.GetSqlAndClear(AIndex);
  try
    AdbSqlAndParams(LAddDb, FInter.Name, LSql);
    LRows := 0;
    if FindParamBooleanReplaced('cnd', true) then
      LRows := dataMain.AddQueryExecute(LAddDb, FInter.Name);
    if FindParam('z', LParam) then begin
      LNum := StrToIntDef(Trim(LParam), -1);
      if LNum < 0 then
        FInter.DoLog('E', '#execsql: z nicht nummerisch oder kleiner 0')
      else
        FExecInter.Values[LNum] := IntToStr(LRows);
    end;
  except
//    Clipboard.AsText := LSql;
    raise;
  end;
end;

function TBafAddDbModule.AdbGetData(AParams: TStrings): string;
var
  LName, LAddDb: string;
  LField: TField;
begin
  if AParams.Count > 2 then begin
    LAddDb := AParams[0];
    if AParams[1] <> '' then
      LName := FInter.Name + '~' + AParams[1]
    else
      LName := FInter.Name;
    if (AParams.Count > 4) and (AnsiLowerCase(AParams[4]) = 'accnd') then begin
      LField := dataMain.AddQueryData(LAddDb, LName).FindField(Trim(AParams[2]));
      if Assigned(LField) then
        result := LField.AsString;
    end
    else
      result := dataMain.AddQueryData(LAddDb, LName).FieldByName(Trim(AParams[2])).AsString;
    if (result = '') and (AParams.Count > 3) then
      result := AParams[3];
  end
  else
    FInter.DoLog('E', '$ADATA: numer of params less 3')
end;

procedure TBafAddDbModule.AdbOpenSql(AIndex: integer);
var
  LSql, LEachRow, LName, LAddDb: string;
  LMax, LRowCount: integer;
  LEachRowTrans: boolean;
  LData: TDataSet;

  procedure lokParams;
  begin
    LName := Trim(FindParamString('n', ''));
    if LName = '' then
      FInter.DoLog('E', '#opensql, n nicht gesetzt');

    LMax := FindParamInteger('m', MaxInt);
    LEachRow := FindParamString('ern', '');
    if LEachRow = '' then
      LEachRow := FindParamStringReplaced('er', '');
    LEachRowTrans := FindParamBoolean('ert', false);
    LName := FInter.Name + '~' + LName;
    LAddDb := FindParamStringReplaced('db', '');
  end; // procedure lokParams

begin
  lokParams;
  LSql := FInter.GetSqlAndClear(AIndex);
  AdbSqlAndParams(LAddDb, LName, LSql);
  if FindParamBooleanReplaced('cnd', true) then begin
    try
      LData := dataMain.AddQueryOpen(LAddDb, LName);
      if (LEachRow <> '') and not LData.Eof then begin
        LRowCount := 0;
        while not LData.Eof do begin
          FExecInter.EachRow(LEachRow, '#asql_open', LEachRowTrans);
          inc(LRowCount);
          if LRowCount >= LMax then begin
            FInter.DoLog('I', Format('OpenSql, Max (%d) erreicht, Schleife abgebrochen', [LMax]));
            Break;
          end;
          LData.Next;
        end;
      end;
    finally
      dataMain.QueryClose(LName);
    end;
  end;
// procedure TBafAddDbModule.AdbOpenSql
end;

procedure TBafAddDbModule.AdbOpenSqlVal(AIndex: integer; AExecInter: TBafCustomInterpreter);
var
  LSql, LFieldName, LParam, LAddDb: string;
  i, LNum: integer;
  LData: TDataSet;
begin
  LSql := FInter.GetSqlAndClear(AIndex);
  LAddDb := FindParamStringReplaced('db', '');
  AdbSqlAndParams(LAddDb, FInter.Name, LSql);
  LData := dataMain.AddQueryOpen(LAddDb, FInter.Name);
  if not LData.Eof then begin
    for i := 0 to LData.Fields.Count - 1 do begin
      LFieldName := LData.Fields[i].FieldName;
      if FindParam('f_' + LFieldName, LParam) then begin
        LNum := StrToIntDef(LParam, -1);
        if LNum >= 0 then
          AExecInter.Values[LNum] := LData.Fields[i].AsString
        else if LParam = '!' then
          FInter.Variable[LFieldName] := LData.Fields[i].AsString
        else
          FInter.Variable[LParam] := LData.Fields[i].AsString;
      end;
    end;
  end;
end;

procedure TBafAddDbModule.AdbOpenSqlValRows(AIndex: integer;
  AExecInter: TBafCustomInterpreter);
var
  LSql, LFieldName, LParam, LSep, LAddDb: string;
  i, LNum: integer;
  LFirst: boolean;
  LData: TDataSet;
begin
  LAddDb := FindParamStringReplaced('db', '');
  LSql := FInter.GetSqlAndClear(AIndex);
  AdbSqlAndParams(LAddDb, FInter.Name, LSql);
  LSep := FindParamStringReplaced('sep', ',');
  LFirst := true;
  LData := dataMain.AddQueryOpen(LAddDb, FInter.Name);
  while not LData.Eof do begin
    for i := 0 to LData.Fields.Count - 1 do begin
      LFieldName := LData.Fields[i].FieldName;
      if FindParam('f_' + LFieldName, LParam) then begin
        LNum := StrToIntDef(LParam, -1);
        if LNum >= 0 then begin
          if LFirst then
            AExecInter.Values[LNum] := LData.Fields[i].AsString
          else
            AExecInter.Values[LNum] := FExecInter.Values[LNum] + LSep + LData.Fields[i].AsString;
        end
        else if LParam = '!' then begin
          if LFirst then
            FInter.Variable[LFieldName] := LData.Fields[i].AsString
          else
            FInter.Variable[LFieldName] := FInter.Variable[LFieldName] + LSep + LData.Fields[i].AsString;
        end
        else begin
          if LFirst then
            FInter.Variable[LParam] := LData.Fields[i].AsString
          else
            FInter.Variable[LParam] := FInter.Variable[LParam] + LSep + LData.Fields[i].AsString;
        end;
      end;
    end;
    LFirst := false;
    LData.Next;
  end;
// procedure TBafAddDbModule.AdbOpenSqlValRows
end;

constructor TBafAddDbModule.Create;
begin
  inherited;

end;

destructor TBafAddDbModule.Destroy;
begin

  inherited;
end;

function TBafAddDbModule.InterpretLine(AExecInter: TBafCustomInterpreter): boolean;
var
  LNum: integer;
  LInter: TBafCustomInterpreter;
begin
  result := true;
  LInter := FExecInter;
  try
    FExecInter := AExecInter;
      if BafIsNumberedFunk(FExecInter.LineF, '#asql_exec', LNum) then AdbExecSql(LNum)      // Fhrt ein SQL-Statement aus
    else if BafIsNumberedFunk(FExecInter.LineF, '#asql_open', LNum) then AdbOpenSql(LNum)      // Fhrt ein SELECT-Statement aus
    else if BafIsNumberedFunk(FExecInter.LineF, '#asql_openval', LNum) then AdbOpenSqlVal(LNum, AExecInter)      // Fhrt ein SELECT-Statement aus und schreibt die Ergebnisse, eine Zeile
    else if BafIsNumberedFunk(FExecInter.LineF, '#asql_openvalrows', LNum) then AdbOpenSqlValRows(LNum, AExecInter)      // Fhrt ein SELECT-Statement aus und schreibt die Ergebnisse, mehrere Zeilen

//    else if FExecInter.LineF = '#defline' then DefLine                               // definiert eine Line, vor #filltables
//    else if FExecInter.LineF = '#sql_defline' then DefLine                               // definiert eine Line, vor #filltables
//    else if FExecInter.LineF = '#filltables' then FillTables                         //
//    else if FExecInter.LineF = '#sql_filltables' then FillTables                         //
//
//    else if FExecInter.LineF = '#intransaction' then InTransaction
//    else if FExecInter.LineF = '#sql_intransaction' then InTransaction
//    else if FExecInter.LineF = '#upsert' then Upsert
//    else if FExecInter.LineF = '#sql_upsert' then Upsert
//
//    else if FExecInter.LineF = '#debugfullrow' then DebugFullRow
//    else if FExecInter.LineF = '#sql_debugfullrow' then DebugFullRow
//
//    else if FExecInter.LineF = '#sql_exporttables' then ExportTables
//    else if FExecInter.LineF = '#sql_importdefs' then ImportDefs
//    else if FExecInter.LineF = '#sql_importtables' then ImportTables

    else result := false;


  finally
    FExecInter := LInter;
  end;



end;

function TBafAddDbModule.ReplaceFunction(ACommand: string; AParams: TStrings;
  var AResult: string): boolean;
begin
  inherited;
  result := true;
//  if ACommand = '$SQL' then AResult := ExecSqlFunc(AParams[0])
//  else if ACommand = '$SQLTEXT' then AResult := GetStringList(StrToIntDef(AParams[0], 1)).Text
   if ACommand = '$ADATA' then AResult := AdbGetData(AParams)
//  else if ACommand = '$ISNULL' then AResult := IsNull(AParams)
//  else if ACommand = '$DATAXML' then AResult := GetDataXml(AParams)
//  else if ACommand = '$DDEF' then AResult := GetDataDef(AParams)


  else result := false;
end;

end.
