unit foSecond;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, System.contnrs,
  FMX.TabControl, FMX.Controls.Presentation, FMX.StdCtrls;

type
  TfrmSecond = class(TForm)
    pnlTop: TPanel;
    TabControl1: TTabControl;
    tabPlus: TTabItem;
    TabItem1: TTabItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TabControl1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    FBafTabList: TObjectList;
    { Private-Deklarationen }
  public
    property BafTabList: TObjectList read FBafTabList;
  end;

var
  frmSecond: TfrmSecond;

implementation

{$R *.fmx}

uses uBafClientTab, dmMain;

procedure TfrmSecond.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  dataMain.UserIni.WriteInteger(CAT_FRM2, 'Left', Left);
  dataMain.UserIni.WriteInteger(CAT_FRM2, 'Top', Top);
  dataMain.UserIni.WriteInteger(CAT_FRM2, 'Width', Width);
  dataMain.UserIni.WriteInteger(CAT_FRM2, 'Height', Height);
  dataMain.UserIni.UpdateFile;
end;

procedure TfrmSecond.FormCreate(Sender: TObject);
begin
  FBafTabList := TObjectList.Create(true);
end;

procedure TfrmSecond.FormDestroy(Sender: TObject);
begin
  FreeAndNil(FBafTabList);
end;

procedure TfrmSecond.FormShow(Sender: TObject);
begin
  Left := dataMain.UserIni.ReadInteger(CAT_FRM2, 'Left', 10);
  Top := dataMain.UserIni.ReadInteger(CAT_FRM2, 'Top', 10);
  Width := dataMain.UserIni.ReadInteger(CAT_FRM2, 'Width', 1000);
  Height := dataMain.UserIni.ReadInteger(CAT_FRM2, 'Height', 700);
end;

procedure TfrmSecond.TabControl1Change(Sender: TObject);
begin
  if TabControl1.ActiveTab = tabPlus then begin
    TabControl1.OnChange := nil;
    try
      TBafClientTab.NewTabSecond('Neuer Tab', '');
    finally
      TabControl1.OnChange := TabControl1Change;
    end;
  end;
end;

end.
