unit foMain;

// this code is under the BAF fair use license (BFUL) - https://bafbal.de/index.php?title=Bful
// the main form

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.TabControl,
  FMX.Controls.Presentation, FMX.StdCtrls, FMX.ExtCtrls, FMX.Layouts, DB,
  System.Contnrs, FMX.Objects, FMX.Edit, FMX.ComboEdit, uBafClientTab,
  FMX.ScrollBox, FMX.Memo, System.Math, FMX.Styles, UBafControls, FMX.TreeView,
  FMX.Menus, uStringIniFile, FMX.ListBox, uBafComboHelper, uBafMenu,
  FMX.DateTimeCtrls, Data.Bind.Components, Data.Bind.ObjectScope, REST.Client,
  FMX.Memo.Types, ScSSHClient;

type
  TfrmMain = class(TForm)
    pnlMenu: TPanel;
    TabControl1: TTabControl;
    tabLog: TTabItem;
    splitMenu: TSplitter;
    pnlBottom: TPanel;
    tbScale: TTrackBar;
    pnlTop: TPanel;
    tabPlus: TTabItem;
    timClose: TTimer;
    cbDebugLog: TCheckBox;
    cbUpsert: TCheckBox;
    cbSelect: TCheckBox;
    cbExec: TCheckBox;
    Label2: TLabel;
    btnXlive: TButton;
    Label1: TLabel;
    btnCode: TButton;
    btnStyleLoad: TButton;
    btnStyleClear: TButton;
    OpenDialog1: TOpenDialog;
    test_treegrid: TButton;
    cbNodeIni: TCheckBox;
    Label3: TLabel;
    cmbSize: TComboBox;
    vsbDebug: TBafVertScrollBox;
    splitDebug: TSplitter;
    btnXlookup: TButton;
    xtranslation: TButton;
    SaveDialog1: TSaveDialog;
    PopupMenu1: TPopupMenu;
    miF9: TMenuItem;
    miF5: TMenuItem;
    cmbUser: TComboBox;
    btnUser: TButton;
    btnMigration: TButton;
    timInit: TTimer;
    memLog: TMemo;
    cmbLogMax: TComboBox;
    cbLogE: TCheckBox;
    cbLogI: TCheckBox;
    cbLogW: TCheckBox;
    cbLogC: TCheckBox;
    btnSelCode: TButton;
    btnOpenCode: TButton;
    edtUser: TEdit;
    btnLoadStyle: TButton;
    cbRequest: TCheckBox;
    cbResponse: TCheckBox;
    cbPerformanceLog: TCheckBox;
    btnPerformanceLogCopy: TButton;
    btnPerformanceLogClear: TButton;
    ScSSHClient1: TScSSHClient;
    procedure tbScaleChange(Sender: TObject);
    procedure TabControl1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnXliveClick(Sender: TObject);
    procedure timCloseTimer(Sender: TObject);
    procedure splitMenuDblClick(Sender: TObject);
    procedure splitDebugDblClick(Sender: TObject);
    procedure btnCodeClick(Sender: TObject);
    procedure test_treegridClick(Sender: TObject);
    procedure cbNodeIniClick(Sender: TObject);
    procedure btnFullHDClick(Sender: TObject);
    procedure cmbSizeChange(Sender: TObject);
    procedure cbDebugLogClick(Sender: TObject);
    procedure btnXlookupClick(Sender: TObject);
    procedure miF9Click(Sender: TObject);
    procedure btnUserClick(Sender: TObject);
    procedure cmbUserChange(Sender: TObject);
    procedure tbScaleDblClick(Sender: TObject);
    procedure btnMigrationClick(Sender: TObject);
    procedure timInitTimer(Sender: TObject);
    procedure btnSelCodeClick(Sender: TObject);
    procedure btnOpenCodeClick(Sender: TObject);
    procedure edtUserKeyUp(Sender: TObject; var Key: Word; var KeyChar: Char;
      Shift: TShiftState);
    procedure btnLoadStyleClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnPerformanceLogCopyClick(Sender: TObject);
    procedure btnPerformanceLogClearClick(Sender: TObject);
    procedure cbPerformanceLogChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    FBafTabList: TObjectList;
    FCloseTab: TBafClientTab;
    FClosePrior: TTabItem;
    FUserHelper: TBafComboHelper;
    procedure RefreshUsers;
    procedure ArrangeOnTheLeft;
    procedure AddInNewTab(ACaption, ACommand: string);
    procedure AddInTab(ACaption, ACommand: string);
    function GetBafTab(ATabItem: TTabItem): TBafClientTab;
  private
    FMenu: TBafMenu;
    procedure CreateMenu;
    procedure SaveMenuIni;
    procedure LoadMenuIni;
    procedure MenuClick(ASender: TBafMenuItem; ACommand: string; AInNewTab: boolean);
  private // Tests
    FDebugIni: TStringIniFile;
    FScale: single;
    FDoubleClickSclale: integer;
  public
    procedure CloseTab(ATab: TBafClientTab; APrior: TTabItem);
    procedure Log(ALogType, ALogText: string);
    procedure DebugIni(AIni: TStringIniFile);
    function GetBafClientTab(ATabItem: TTabItem; var ATab: TBafClientTab): boolean;
    procedure LoadMenu;
    procedure Init;
    procedure OpenCode(ACommand: string);
    procedure SpecialPageRefresh(ADoAp: boolean = false);
    property BafTabList: TObjectList read FBafTabList;
    property Scale: single read FScale;
    property DoubleClickSclale: integer
        read FDoubleClickSclale write FDoubleClickSclale;
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.fmx}

uses dmMain, foBafCode, foDebugNodeIni, foDebugLog, foBafHistory, uBafDataCache,
    uBafTranslationModule, foBafMigration, uBafFmxUtils, foBafDmCompare,
  uBafTypes, foBafDbDebug, uOsStuff, foLogin, dmWD;



procedure TfrmMain.AddInNewTab(ACaption, ACommand: string);
begin
  TabControl1.OnChange := nil;
  try
    TBafClientTab.NewTab(ACaption, ACommand, false);
  finally
    TabControl1.OnChange := TabControl1Change;
  end;
end;

procedure TfrmMain.AddInTab(ACaption, ACommand: string);
var
  LTab: TBafClientTab;
begin
  TabControl1.OnChange := nil;
  try
    LTab := GetBafTab(TabControl1.ActiveTab);
    if Assigned(LTab) then begin
      LTab.DoCommand(ACommand);
      LTab.Caption := ACaption;
    end
    else
      TBafClientTab.NewTab(ACaption, ACommand, false);
  finally
    TabControl1.OnChange := TabControl1Change;
  end;
end;

procedure TfrmMain.ArrangeOnTheLeft;
begin
  vsbDebug.Position.X := 0;
  splitDebug.Position.X := vsbDebug.Width;
  pnlMenu.Position.X := splitDebug.Position.X + splitDebug.Width;
  splitMenu.Position.X := pnlMenu.Position.X + pnlMenu.Width;
end;

procedure TfrmMain.btnCodeClick(Sender: TObject);
begin
  frmBafCode.Execute;
end;

procedure TfrmMain.btnFullHDClick(Sender: TObject);
begin
  Width := 1920;
  Height := 1080;
end;

procedure TfrmMain.btnLoadStyleClick(Sender: TObject);
begin
//  TStyleManager.SetStyle(nil);
//  if OpenDialog1.Execute then
//    TStyleManager.SetStyleFromFile(OpenDialog1.FileName);
end;

procedure TfrmMain.btnMigrationClick(Sender: TObject);
begin
  frmBafMigration.Execute;
end;

procedure TfrmMain.btnOpenCodeClick(Sender: TObject);
begin
  OpenCode('open');
end;

procedure TfrmMain.btnSelCodeClick(Sender: TObject);
begin
  OpenCode('sel');
end;

procedure TfrmMain.btnUserClick(Sender: TObject);
begin
  gvBafDataCache.RefreshAll;
  edtUser.Text := '';
  RefreshUsers;
end;

procedure TfrmMain.btnXliveClick(Sender: TObject);
begin
  AddInNewTab('xlive', 'xlive');
end;

procedure TfrmMain.btnXlookupClick(Sender: TObject);
begin
  AddInNewTab('xlookup', 'xlookup');
end;

procedure TfrmMain.cbDebugLogClick(Sender: TObject);
begin
  if not cbDebugLog.IsChecked then begin
    frmDebugLog.Show;
  end
  else begin
    frmDebugLog.OnClose := nil;
    try
      frmDebugLog.Close;
    finally
      frmDebugLog.OnClose := frmDebugLog.FormClose;
    end;
  end;
end;

procedure TfrmMain.cbNodeIniClick(Sender: TObject);
begin
  if not cbNodeIni.IsChecked then begin
    frmDebugNodeIni.Show;
    if Assigned(FDebugIni) then
      frmDebugNodeIni.memDebug.Lines.Text := FDebugIni.AsString;
  end
  else begin
    frmDebugNodeIni.OnClose := nil;
    try
      frmDebugNodeIni.Close;
    finally
      frmDebugNodeIni.OnClose := frmDebugNodeIni.FormClose;
    end;
  end;
end;

procedure TfrmMain.cbPerformanceLogChange(Sender: TObject);
begin
  gv_performancelog := cbPerformanceLog.IsChecked;
end;

procedure TfrmMain.CloseTab(ATab: TBafClientTab; APrior: TTabItem);
begin
  FCloseTab := ATab;
  FClosePrior := APrior;
  timClose.Enabled := true;
end;

procedure TfrmMain.cmbSizeChange(Sender: TObject);
begin
  case cmbSize.ItemIndex of
    0: begin
      Width := 1920;
      Height := 1080;
    end;
    1: begin
      Width := round(1920 / 1.2);
      Height := round(1080 / 1.2);
    end;
    2: begin
      Width := round(1920 / 1.25);
      Height := round(1080 / 1.25);
    end;
    3: begin
      Width := round(1920 / 1.5);
      Height := round(1080 / 1.5);
    end;
    4: begin
      Width := round(1920 / 1.75);
      Height := round(1080 / 1.75);
    end;
  end;
end;

procedure TfrmMain.cmbUserChange(Sender: TObject);
begin
  dataMain.RightUserId := FUserHelper.GetGuid(cmbUser);
  gvBafDataCache.RefreshUserGroups(dataMain.RightUserId);
  LoadMenu;
  TabControl1Change(nil);
end;

procedure TfrmMain.CreateMenu;
begin
  FMenu := TBafMenu.Place(Self, pnlMenu);
  FMenu.OnMenuClick := MenuClick;
//  FMenu.StyleLookup := 'baftreeviewmenu';
  LoadMenu;
end;

procedure TfrmMain.DebugIni(AIni: TStringIniFile);
begin
  FDebugIni := AIni;
  if frmDebugNodeIni.Visible then
    frmDebugNodeIni.memDebug.Lines.Text := AIni.AsString;
end;

procedure TfrmMain.edtUserKeyUp(Sender: TObject; var Key: Word;
  var KeyChar: Char; Shift: TShiftState);
begin
  if Key = vkReturn then
    RefreshUsers;
end;

procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  BafFormPos2Ini(Self, dataMain.UserIni, CAT_FRM);

  dataMain.UserIni.WriteFloat(CAT_FRM, 'Scale', tbScale.Value);
  dataMain.UserIni.WriteFloat(CAT_FRM, 'DebugWidth', vsbDebug.Width);
  dataMain.UserIni.WriteFloat(CAT_FRM, 'MenuWidth', pnlMenu.Width);
  SaveMenuIni;  // UpdateFile there...
  FreeAndNil(FBafTabList);
//  FreeAndNil(dataMain);
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  FBafTabList := TObjectList.Create(true);
  pnlTop.Visible := false;
end;

procedure TfrmMain.FormShow(Sender: TObject);
begin
  if TfrmLogin.Login then begin
    pnlTop.Visible := true;
    Application.CreateForm(TdataWD, dataWD);
    gvInterType := itClient;
    Application.CreateForm(TdataMain, dataMain);
    Application.CreateForm(TfrmBafDbDebug, frmBafDbDebug);
    Application.CreateForm(TfrmBafCode, frmBafCode);
    Application.CreateForm(TfrmDebugNodeIni, frmDebugNodeIni);
    Application.CreateForm(TfrmDebugLog, frmDebugLog);
    Application.CreateForm(TfrmBafMigration, frmBafMigration);
    Application.CreateForm(TfrmBafDmCompare, frmBafDmCompare);
    timInit.Enabled := true;
  end
  else
    Application.Terminate;
end;

function TfrmMain.GetBafClientTab(ATabItem: TTabItem;
    var ATab: TBafClientTab): boolean;
var
  i: integer;
begin
  result := false;
  for i := 0 to ATabItem.ComponentCount - 1 do begin
    if FClosePrior.Components[i] is TBafClientTab then begin
      result := true;
      ATab := TBafClientTab(FClosePrior.Components[i]);
    end;
  end;
end;

function TfrmMain.GetBafTab(ATabItem: TTabItem): TBafClientTab;
var
  i: integer;
  LTab: TBafClientTab;
begin
  result := nil;
  for i := 0 to FBafTabList.Count - 1 do begin
    LTab := FBafTabList[i] as TBafClientTab;
    if (LTab.Owner = ATabItem) then begin
      result := LTab;
      exit;
    end;
  end;
end;

procedure TfrmMain.Init;
begin
  gvStart := 4100;
  tbScale.Value := dataMain.UserIni.ReadFloat(CAT_FRM, 'Scale', 100);
  vsbDebug.Width := dataMain.UserIni.ReadFloat(CAT_FRM, 'DebugWidth', 120);
  pnlMenu.Width := dataMain.UserIni.ReadFloat(CAT_FRM, 'MenuWidth', 120);
  splitMenu.Locked := not pnlMenu.Visible;
  ArrangeOnTheLeft;

  gvStart := 4200;
  RefreshUsers;
  gvStart := 4300;
  gvBafDataCache.IsAdmin := gvBafDataCache.RightIsAdmin;
  if (vsbDebug.Width = 0) or not gvBafDataCache.IsAdmin then begin
    vsbDebug.Width := 0;
    vsbDebug.Visible := false;
  end;
  cmbUser.Enabled := gvBafDataCache.IsAdmin;
//  btnUser.Enabled := gvBafDataCache.IsAdmin;
  gvStart := 4400;
  LoadCommands;
  gvStart := 4500;
  CreateMenu;
  gvStart := 4600;
end;

procedure TfrmMain.LoadMenu;
var
  LCat: TBafMenuCategory;
  LItem: TBafMenuItem;
  LSql, LCatName, s: string;
  LParams: TBafParams;
  LDataSet: TDataset;
begin
  if FMenu = nil then
    exit;
  LCat := nil;
  SaveMenuIni;
  FMenu.Categories.Clear;
//  FMenu.OnPaint := FMenu.GridPaint;

  try
    case dataMain.DefaultCon.BafGen of
      bg302, bg303, bg303TT: LSql := dataMain.GetSqlTextFromDevtext('_system_loadmenu_202', '');
      else
        LSql := dataMain.GetSqlTextFromDevtext('_system_loadmenu', '');
    end;
  except

  end;

  if LSql = '' then begin
    case dataMain.DefaultCon.BafGen of
      bg303TT: exit;
      bg302, bg303:
        LSql := 'select c.name  as catname, i.name, i.command  from menu_category c '
            + 'inner join menu_item i on c.menu_category_id = i.menu_category_id and i.status = 1 '
            +	'inner join menu_item2group g on g.menu_item_id = i.menu_item_id and g.status = 1 '
            + 'inner join user_group g1 on g1.user_group_id = g.user_group_id and g1.status = 1 '
            + 'inner join user_group g2 on g2.path like g1.path || ''%'' and g2.status = 1 '
            + 'inner join user_user2group t on t.user_group_id = g2.user_group_id and t.status = 1 '
            + 'and t.user_user_id = :kid      where c.status = 1     order by c.csort, i.csort ';
      else
        LSql := 'select c.name  as catname, i.name, i.command  from menu_category c '
            + 'inner join menu_item i on c.menu_category_id = i.menu_category_id and i.status = ''1'' '
            +	'inner join menu_item2group g on g.menu_item_id = i.menu_item_id and g.status = ''1'' '
            + 'inner join user_group g1 on g1.user_group_id = g.user_group_id and g1.status = ''1'' '
            + 'inner join user_group g2 on g2.path like g1.path || ''%'' and g2.status = ''1'' '
            + 'inner join user_user2group t on t.user_group_id = g2.user_group_id and t.status = ''1'' '
            + 'and t.user_user_id = :kid      where c.status = ''1''     order by c.sort, i.sort ';
    end;
  end;
  LParams := dataMain.QueryPrepare(dataMain.DefaultCon, 'menu', LSql);
  LParams.ParamAsString('kid', dataMain.RightUserId);
  LDataSet := dataMain.QueryOpen(dataMain.DefaultCon, 'menu');
  while not LDataSet.Eof do begin
    s := TBafTranslationModule.BafTranslate(LDataSet.FieldByName('catname').AsString);
    if s <> LCatName then begin
      LCatName := s;
      LCat := FMenu.Categories.Add;
      LCat.Text := s;
      LCat.Expanded := true;
    end;
    if Assigned(LCat) and (LCat.Text = s) then begin
      LItem := LCat.Items.Add;
      LItem.Text := TBafTranslationModule.BafTranslate(LDataSet.FieldByName('name').AsString);
      LItem.Command := LDataSet.FieldByName('command').AsString;
    end;
    LDataSet.Next;
  end;
  LoadMenuIni;
  Application.ProcessMessages;
  FMenu.Repaint;
end;

procedure TfrmMain.LoadMenuIni;
var
  i: integer;
begin
  for i := 0 to FMenu.Categories.Count - 1 do
    FMenu.Categories.Items[i].Expanded := dataMain.UserIni.ReadBool(CAT_MENU,
        FMenu.Categories.Items[i].Text, true);
end;

procedure TfrmMain.Log(ALogType, ALogText: string);
var
  s: string;
  LMax: integer;
begin
  s := FormatDateTime('hh:mm:ss', now) + Format(' - %s - %s', [ALogType, ALogText]);
  case ALogType[1] of
    'C': if cbLogC.IsChecked then
      memLog.Lines.Add(s);
    'E': if cbLogE.IsChecked then
      memLog.Lines.Add(s);
    'W': if cbLogW.IsChecked then
      memLog.Lines.Add(s);
    'I': if cbLogI.IsChecked then
      memLog.Lines.Add(s);
  end;
  case cmbLogMax.ItemIndex of
    0: LMax := 42;
    1: LMax := 1337;
  else
    LMax := 10000;
  end;
  while memLog.Lines.Count > LMax do
    memLog.Lines.Delete(0);
end;

procedure TfrmMain.MenuClick(ASender: TBafMenuItem; ACommand: string; AInNewTab: boolean);
begin
  if AInNewTab then
    AddInNewTab(ACommand, ACommand)
  else
    AddInTab(ACommand, ACommand);
end;

procedure TfrmMain.miF9Click(Sender: TObject);
var
  LTab: TBafClientTab;
begin
  LTab := GetBafTab(TabControl1.ActiveTab);
  if Assigned(LTab) and (AnsiCompareText(LTab.Caption, 'xlive') = 0) then
    LTab.DoCommand('#xlive_F9');
end;

procedure TfrmMain.OpenCode(ACommand: string);
var
  LCommand: string;
  p, i: integer;
  LInQuote: boolean;
begin
//  FIni.AsString := memDebug.Lines.Text;
  LCommand := FDebugIni.ReadString(SEC_ADD, ACommand, '');
  if ACommand = 'sel' then begin
    p := Pos('#page_fill', LCommand);
    if p > 0 then begin
      p := Pos(' d=', LCommand);
      LCommand := copy(LCommand, p + 3, MaxInt);
    end;
  end;
  LInQuote := false;
  for i := 1 to Length(LCommand) do begin
    case LCommand[i] of
      '"': LInQuote := not LInQuote;
      '(', ' ': if not LInQuote then begin
        LCommand := copy(LCommand, 1, i - 1);
        Break;
      end;
    end;
  end;
  frmBafCode.Execute(LCommand);
end;

procedure TfrmMain.RefreshUsers;
var
  LSql: string;
begin
  try
    cmbUser.OnChange := nil;
    try
      LSql := dataMain.GetSqlTextFromDevtext('_user_lookup', '');
      if LSql <> '' then begin
        if FUserHelper = nil then
          FUserHelper := TBafComboHelper.Create(false);
        FUserHelper.FillFromQueryParam(LSql, 'ckey', 'cvalue', '%' + edtUser.Text + '%');
      end
      else begin
        case dataMain.DefaultCon.BafGen of
          bg303TT: FUserHelper := gvBafDataCache.Special['system_user_lu'];
          else
            FUserHelper := gvBafDataCache.Special['system_user_all'];
        end;
      end;
      FUserHelper.FillComboBox(cmbUser);
      if (cmbUser.Items.Count = 1) then
        cmbUser.ItemIndex := 0
      else
        FUserHelper.SetGuid(cmbUser, dataMain.UserGuid);
    finally
      cmbUser.OnChange := cmbUserChange;
    end;
    cmbUserChange(nil);
  except
    on E: Exception do
      ShowMessage('Error while loading users list: ' + E.Message
          + '   ' + IntToStr(gvStart) + '   ' + gvStartText);
  end;
end;

procedure TfrmMain.SaveMenuIni;
var
  i: integer;
begin
  if Assigned(FMenu) then begin
    for i := 0 to FMenu.Categories.Count - 1 do
      dataMain.UserIni.WriteBool(CAT_MENU, FMenu.Categories.Items[i].Text,
          FMenu.Categories.Items[i].Expanded);
    dataMain.UserIni.UpdateFile;
  end;
end;

procedure TfrmMain.SpecialPageRefresh(ADoAp: boolean = false);
const
  CDIFF = 0.34;
begin
{ TODO -cStriche : Code entfernt }
//  if vsbDebug.Width > 10 then
//    vsbDebug.Width := vsbDebug.Width - CDIFF;
//  pnlMenu.Width := pnlMenu.Width - CDIFF;
//  if ADoAp then
//    Application.ProcessMessages;
//  pnlMenu.Width := pnlMenu.Width + CDIFF;
//  if vsbDebug.Width > (10 - CDIFF) then
//    vsbDebug.Width := vsbDebug.Width + CDIFF;
end;

procedure TfrmMain.splitDebugDblClick(Sender: TObject);
begin
  if gvBafDataCache.IsAdmin then begin
    vsbDebug.Width := IfThen(vsbDebug.Width > 0, 0, 106);
    vsbDebug.Visible := (vsbDebug.Width > 0) and gvBafDataCache.IsAdmin;
    ArrangeOnTheLeft;
  end;
end;

procedure TfrmMain.splitMenuDblClick(Sender: TObject);
begin
  pnlMenu.Width := IfThen(pnlMenu.Width > 0, 0, 20);
  ArrangeOnTheLeft;
end;

procedure TfrmMain.TabControl1Change(Sender: TObject);
begin
  if TabControl1.ActiveTab = tabPlus then begin
    TabControl1.OnChange := nil;
    try
      TBafClientTab.NewTab('Neuer Tab', '', false);
    finally
      TabControl1.OnChange := TabControl1Change;
    end;
  end
  else
    GetBafTab(TabControl1.ActiveTab).RightUserId := dataMain.RightUserId;
end;

procedure TfrmMain.tbScaleChange(Sender: TObject);
begin
  FScale := tbScale.Value / 100;
  pnlTop.Scale.X := FScale;
  pnlTop.Scale.Y := FScale;
  pnlTop.RecalcSize;
  frmBafCode.pnlDesk.Scale.X := FScale;
  frmBafCode.pnlDesk.Scale.Y := FScale;
  frmBafCode.pnlDesk.RecalcSize;
  frmDebugNodeIni.pnlDesk.Scale.X := FScale;
  frmDebugNodeIni.pnlDesk.Scale.Y := FScale;
  frmDebugNodeIni.pnlDesk.RecalcSize;
  frmDebugLog.pnlDesk.Scale.X := FScale;
  frmDebugLog.pnlDesk.Scale.Y := FScale;
  frmDebugLog.pnlDesk.RecalcSize;
  frmBafDbDebug.pnlDesk.Scale.X := FScale;
  frmBafDbDebug.pnlDesk.Scale.Y := FScale;
  frmBafDbDebug.pnlDesk.RecalcSize;
  frmBafMigration.pnlDesk.Scale.X := FScale;
  frmBafMigration.pnlDesk.Scale.Y := FScale;
  frmBafMigration.pnlDesk.RecalcSize;
  frmBafDmCompare.pnlDesk.Scale.X := FScale;
  frmBafDmCompare.pnlDesk.Scale.Y := FScale;
  frmBafDmCompare.pnlDesk.RecalcSize;
end;

procedure TfrmMain.tbScaleDblClick(Sender: TObject);
begin
  tbScale.Value := DoubleClickSclale;
end;

procedure TfrmMain.test_treegridClick(Sender: TObject);
var
  s: string;
begin
  TabControl1.OnChange := nil;
  try
//    TBafClientTab.NewTab('test_reise', 'test_reise');
    s := (Sender as TButton).Text;
    TBafClientTab.NewTab(s, s, false);
  finally
    TabControl1.OnChange := TabControl1Change;
  end;
end;

procedure TfrmMain.timCloseTimer(Sender: TObject);
var
  i: integer;
  LTab: TBafClientTab;
begin
  timClose.Enabled := false;
  FBafTabList.Remove(FCloseTab);
  TabControl1.Delete(TabControl1.TabIndex);

  for i := 0 to TabControl1.TabCount - 1 do begin
    if TabControl1.Tabs[i] = FClosePrior then begin
      TabControl1.ActiveTab := FClosePrior;
      if GetBafClientTab(FClosePrior, LTab) then
        LTab.Inter.Return2Tab;
      Break;
    end;
  end;

  if TabControl1.ActiveTab = tabLog then
    TabControl1.ActiveTab := TabControl1.Tabs[1];
  if TabControl1.ActiveTab = tabPlus then
    TabControl1.ActiveTab := TabControl1.Tabs[1];
  if TabControl1.ActiveTab = tabPlus then
    TabControl1.ActiveTab := tabLog;
end;

procedure TfrmMain.timInitTimer(Sender: TObject);
begin
  try
    timInit.Enabled := false;
    gvStart := 1000;
    dataMain.Init;
    gvStart := 2000;
    Caption := dataMain.ProgName + BAF_VERSION + ' - ' + dataMain.DBName;
    BafIni2FormPos(Self, dataMain.UserIni, CAT_FRM, 10, 10, 1000, 700);
    BafIni2FormPos(frmBafCode, dataMain.UserIni, CAT_CODE, 10, 10, 1000, 700);
    frmBafCode.cmbCodeFontSize.ItemIndex
        := dataMain.UserIni.ReadInteger(CAT_CODE, 'FontSize', 3);
    BafIni2FormPos(frmDebugNodeIni, dataMain.UserIni, CAT_DEBUG_NODE, 10, 10, 400, 300);
    BafIni2FormPos(frmBafMigration, dataMain.UserIni, CAT_MIG, 10, 10, 1000, 700);
    BafIni2FormPos(frmBafDmCompare, dataMain.UserIni, CAT_MIGC, 10, 10, 1000, 700);
    gvStart := 3000;
    frmBafMigration.Init;
    gvStart := 4000;
    Init;
    gvStart := 5000;
    TabControl1.ActiveTab := tabPlus;
    SpecialPageRefresh(true);
  except
    on E: Exception do begin
      ShowMessage(IntToStr(gvStart) + '   ' + gvStartText);
      raise;
    end;
  end;
end;

procedure TfrmMain.btnPerformanceLogClearClick(Sender: TObject);
begin
  gv_plog.Clear;
end;

procedure TfrmMain.btnPerformanceLogCopyClick(Sender: TObject);
begin
  Clipboard.AsText := gv_plog.Text;
end;

end.


