unit foDebugNodeIni;

// this code is under the BAF fair use license (BFUL) - https://bafbal.de/index.php?title=Bful
// the node ini debug window

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, uStringIniFile,
  FMX.Controls.Presentation, FMX.ScrollBox, FMX.Memo, FMX.StdCtrls,
  FMX.Memo.Types;

type
  TfrmDebugNodeIni = class(TForm)
    memDebug: TMemo;
    pnlDesk: TPanel;
    btnCodeSelect: TButton;
    btnCodeOpen: TButton;
    cbStayOnTop: TCheckBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnCodeSelectClick(Sender: TObject);
    procedure btnCodeOpenClick(Sender: TObject);
    procedure cbStayOnTopChange(Sender: TObject);
  private
    FIni: TStringIniFile;
  public
    { Public-Deklarationen }
  end;

var
  frmDebugNodeIni: TfrmDebugNodeIni;

implementation

{$R *.fmx}

uses foMain, dmMain, uBafFmxUtils, uBafTypes, foBafCode;

procedure TfrmDebugNodeIni.btnCodeOpenClick(Sender: TObject);
begin
  frmMain.OpenCode('open');
end;

procedure TfrmDebugNodeIni.btnCodeSelectClick(Sender: TObject);
begin
  frmMain.OpenCode('sel');
end;

procedure TfrmDebugNodeIni.cbStayOnTopChange(Sender: TObject);
begin
  if cbStayOnTop.IsChecked then
    frmDebugNodeIni.FormStyle := TFormStyle.StayOnTop
  else
    frmDebugNodeIni.FormStyle := TFormStyle.Normal;
end;

procedure TfrmDebugNodeIni.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  frmMain.cbNodeIni.IsChecked := false;
end;

procedure TfrmDebugNodeIni.FormCreate(Sender: TObject);
begin
  FIni := TStringIniFile.Create('');
end;

procedure TfrmDebugNodeIni.FormDestroy(Sender: TObject);
begin
  BafFormPos2Ini(Self, dataMain.UserIni, CAT_DEBUG_NODE);
  FreeAndNil(FIni);
end;

end.
