unit foDebugLog;

// this code is under the BAF fair use license (BFUL) - https://bafbal.de/index.php?title=Bful
// the debug log window

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.TabControl,
  FMX.Controls.Presentation, FMX.StdCtrls;

type
  TfrmDebugLog = class(TForm)
    pnlDesk: TPanel;
    TabControl1: TTabControl;
    tabStart: TTabItem;
    timClose: TTimer;
    cbStayOnTop: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure timCloseTimer(Sender: TObject);
    procedure cbStayOnTopChange(Sender: TObject);
  private
    FPosAusIni: boolean;
    FCloseIndex: integer;
  public
    procedure CloseTab(ATab: TTabItem);
  end;

var
  frmDebugLog: TfrmDebugLog;

implementation

{$R *.fmx}

uses dmMain, foMain, uBafFmxUtils;

procedure TfrmDebugLog.cbStayOnTopChange(Sender: TObject);
begin
  if cbStayOnTop.IsChecked then
    frmDebugLog.FormStyle := TFormStyle.StayOnTop
  else
    frmDebugLog.FormStyle := TFormStyle.Normal;
end;

procedure TfrmDebugLog.CloseTab(ATab: TTabItem);
begin
  ATab.Free;
  timClose.Enabled := true;
end;

procedure TfrmDebugLog.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  frmMain.cbDebugLog.IsChecked := false;
end;

procedure TfrmDebugLog.FormDestroy(Sender: TObject);
begin
  BafFormPos2Ini(Self, dataMain.UserIni, CAT_DEBUG);
  dataMain.UserIni.UpdateFile;
end;

procedure TfrmDebugLog.FormShow(Sender: TObject);
begin
  if not FPosAusIni then begin
    BafIni2FormPos(Self, dataMain.UserIni, CAT_DEBUG, 10, 10, 400, 300);
    FPosAusIni := true;
  end;
end;

procedure TfrmDebugLog.timCloseTimer(Sender: TObject);
begin
  timClose.Enabled := false;
  TabControl1.ActiveTab := tabStart;
end;

end.
