unit foBafDmCompare;

// this code is under the BAF fair use license (BFUL) - https://bafbal.de/index.php?title=Bful
// for comparing data in different DB

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, Data.DB,
  FMX.Controls.Presentation, FMX.StdCtrls, FMX.Grid, System.Rtti,
  FMX.Grid.Style, FMX.ScrollBox;

type
  TfrmBafDmCompare = class(TForm)
    pnlDesk: TPanel;
    sgCompare: TStringGrid;
    btnClose: TButton;
    scField: TStringColumn;
    scSource: TStringColumn;
    scDest: TStringColumn;
    lblRow: TLabel;
    procedure FormDestroy(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    procedure ShowDialog(AGrid: TStringGrid; ARow: integer; ADataset: TDataset);
  end;

var
  frmBafDmCompare: TfrmBafDmCompare;

implementation

{$R *.fmx}

uses uBafFmxUtils, dmMain, foBafMigration;

procedure TfrmBafDmCompare.FormDestroy(Sender: TObject);
begin
  BafFormPos2Ini(Self, dataMain.UserIni, CAT_MIGC);
end;

procedure TfrmBafDmCompare.FormResize(Sender: TObject);
var
  LWidth: single;
begin
  LWidth := (pnlDesk.Width  - 24 - scField.Width) / 2;
  scSource.Width := LWidth;
  scDest.Width := LWidth;
end;

procedure TfrmBafDmCompare.ShowDialog(AGrid: TStringGrid; ARow: integer;
    ADataset: TDataset);
var
  i: integer;
  LFieldName: string;
  LField: TField;
begin
  lblRow.Text := AGrid.Cells[0, ARow];
  for i := 2 to AGrid.ColumnCount - 2 do begin
    sgCompare.RowCount := i - 1;
    LFieldName := AGrid.Columns[i].Header;
    sgCompare.Cells[0, i - 2] := LFieldName;
    sgCompare.Cells[1, i - 2] := AGrid.Cells[i, ARow];
    LField := ADataset.FindField(LFieldName);
    if Assigned(LField) then
      sgCompare.Cells[2, i - 2] := LField.AsString;
  end;
  ShowModal;
end;

end.
