unit foBafDlg;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, uBafInterpreter,
  FMX.Controls.Presentation, FMX.StdCtrls;

type
  TfrmDlg = class(TForm)
    pnlDesk: TPanel;
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    FDef: string;
    procedure Scale;
    procedure Init(AType, ACmd, AIni: string);
  protected
    FInter: TBafInterpreter;
    procedure InterNeedCommand(AInter: TBafInterpreter; AName: string; ACode: TStrings);
    procedure InterLog(AInter: TBafInterpreter; ALogType, ALogText: string);
    procedure InterNeedInfo(AInter: TBafInterpreter; AName, AParam: string; var AInfo: string);
    procedure InterClose(Sender: TObject);
  public
    class function ShowDlg(ATitle, AType, ADef, ACmd: string;
        var AIni, AResult: string): boolean;
  end;

var
  frmDlg: TfrmDlg;

implementation

{$R *.fmx}

uses foMain, dmMain, uBafFmxUtils, uBafTypes, uBafInterpreterModuleList;

{ TfrmDlg }


procedure TfrmDlg.FormDestroy(Sender: TObject);
begin
  BafFormPos2Ini(Self, dataMain.UserIni, FDef);
end;

procedure TfrmDlg.FormShow(Sender: TObject);
begin
  BafIni2FormPos(Self, dataMain.UserIni, FDef, 10, 10, 300, 400);
end;



procedure TfrmDlg.Init(AType, ACmd, AIni: string);
begin
  FInter := TBafInterpreter.Create(itClient);
  FInter.Inter := FInter;
  FInter.Name := '#dlg';
  FInter.OnNeedCommand := InterNeedCommand;
  FInter.OnNeedInfo := InterNeedInfo;
  FInter.OnLog := InterLog;
  FInter.OnClose:= InterClose;
  FInter.ParentPanel := pnlDesk;
  TBafInterpreterModuleList.CreateModule(FInter);
  FInter.GetIni(1).AsString := AIni;
  FInter.Execute(ACmd);
end;

procedure TfrmDlg.InterClose(Sender: TObject);
begin
  Close;
end;

procedure TfrmDlg.InterLog(AInter: TBafInterpreter; ALogType, ALogText: string);
begin
  frmMain.Log(ALogType, ALogText);
end;

procedure TfrmDlg.InterNeedCommand(AInter: TBafInterpreter; AName: string;
  ACode: TStrings);
begin
  AName := AnsiLowerCase(AName);
  if not dataMain.GetCommand(AName, ACode) then
    InterLog(nil, 'E', 'Kommando nicht gefunden: ' + AName);
end;

procedure TfrmDlg.InterNeedInfo(AInter: TBafInterpreter; AName, AParam: string;
  var AInfo: string);
begin
  AName := AnsiLowerCase(AName);
  if AName = 'usrid' then AInfo := dataMain.UserGuid
  else if AName = 'rightusrid' then AInfo := dataMain.RightUserId
  else if AName = 'root' then AInfo := dataMain.Root
  else if AName = 'usrroot' then AInfo := dataMain.UserRoot
  else if AName = 'usrini' then AInfo := dataMain.UserIni.ReadString(CAT_USRDATA, AParam, '')
  else if AName = 'ini' then AInfo := dataMain.Ini.ReadString(CAT_DATA, AParam, '')
  ;
end;

procedure TfrmDlg.Scale;
begin
  pnlDesk.Scale.X := frmMain.tbScale.Value / 100;
  pnlDesk.Scale.Y := pnlDesk.Scale.X;
  pnlDesk.RecalcSize;
end;

class function TfrmDlg.ShowDlg(ATitle, AType, ADef, ACmd: string;
    var AIni, AResult: string): boolean;
var
  LDialog: TfrmDlg;
begin
  LDialog := TfrmDlg.Create(nil);
  try
    LDialog.FDef := ADef;
    LDialog.Caption := ATitle;
    LDialog.Scale;
    LDialog.Init(AType, ACmd, AIni);
    LDialog.ShowModal;
    AResult := LDialog.FInter.Variable['result'];
    AIni := LDialog.FInter.GetIni(1).AsString;
  finally
    LDialog.Free;
  end;
// class function TfrmDlg.ShowDlg
end;

end.
