unit foBafDialog;

// this code is under the BAF fair use license (BFUL) - https://bafbal.de/index.php?title=Bful
// a dialog

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.StdCtrls,
  FMX.ScrollBox, FMX.Memo, FMX.Controls.Presentation, System.Math,
  FMX.Memo.Types;

type
  TfrmBafDialog = class(TForm)
    pnlYesNo: TPanel;
    Panel2: TPanel;
    pnlOk: TPanel;
    Memo1: TMemo;
    btnYes: TButton;
    btnNo: TButton;
    btnOk: TButton;
    Panel1: TPanel;
    pnlDesk: TPanel;
    pnlProgress: TPanel;
    btnAbort: TButton;
    pnlProgress2: TPanel;
    ProgressBar1: TProgressBar;
    procedure btnAbortClick(Sender: TObject);
  private
    FOnAbort: TNotifyEvent;
    procedure SetPosition(AParentForm: TForm);
    procedure Scale;
    procedure CalcSize;
  public
    class procedure ShowMessage(ATitle, AMessage: string; AParentForm: TForm);
    class function DialogYesNow(ATitle, AMessage: string; AParentForm: TForm): boolean;
    class function InitProgress(ATitle, AMessage: string; AParentForm: TForm;
        AOnAbort: TNotifyEvent): TfrmBafDialog;
  end;


implementation

{$R *.fmx}

uses foMain, uBafTranslationModule;

{ TfrmBafDialog }

procedure TfrmBafDialog.btnAbortClick(Sender: TObject);
begin
  if Assigned(FOnAbort) then
    FOnAbort(Self);
end;

procedure TfrmBafDialog.CalcSize;
var
  i: integer;
  LTextWidth: Single;
begin
  Height := round((Memo1.Lines.Count * 16 + 120) * frmMain.tbScale.Value / 100);
  if Height > Screen.Height then
    Height := round(0.9 * Screen.Height);
  LTextWidth := 0;
  for i := 0 to Memo1.Lines.Count - 1 do
    LTextWidth := System.Math.Max(LTextWidth,
      Memo1.Canvas.TextWidth(Memo1.Lines[i]));
  LTextWidth := System.Math.Max(LTextWidth + 40, 200);
  Width := round(System.Math.Min(Screen.Width, LTextWidth * frmMain.tbScale.Value / 100));
end;

class function TfrmBafDialog.DialogYesNow(ATitle, AMessage: string;
    AParentForm: TForm): boolean;
var
  LDialog: TfrmBafDialog;
begin
  LDialog := TfrmBafDialog.Create(nil);
  try
    LDialog.Caption := ATitle;
    LDialog.Memo1.Lines.Text := AMessage;
    LDialog.pnlOk.Visible := false;
    LDialog.pnlProgress.Visible := false;
    LDialog.pnlProgress2.Visible := false;
    LDialog.Scale;
    LDialog.CalcSize;
    LDialog.SetPosition(AParentForm);
    LDialog.btnYes.Text := TBafTranslationModule.BafTranslate('$T(Yes)');
    LDialog.btnNo.Text := TBafTranslationModule.BafTranslate('$T(No)');
    result := LDialog.ShowModal = mrYes;
  finally
    LDialog.Free;
  end;
end;

class function TfrmBafDialog.InitProgress(ATitle, AMessage: string;
  AParentForm: TForm; AOnAbort: TNotifyEvent): TfrmBafDialog;
begin
  result := TfrmBafDialog.Create(nil);
  result.Caption := ATitle;
  result.Memo1.Lines.Text := AMessage;
  result.Memo1.StyleLookup := 'memolabelstyle';
  result.Memo1.ShowScrollBars := false;
  result.pnlYesNo.Visible := false;
  result.pnlOk.Visible := false;
  result.Scale;
  result.CalcSize;
  result .Height := result.Height + 24;
  result.SetPosition(AParentForm);
  result.btnAbort.Text := TBafTranslationModule.BafTranslate('$T(Abort)');
  result.FormStyle := TFormStyle.StayOnTop;
  result.FOnAbort := AOnAbort;
  result.Show;
end;

procedure TfrmBafDialog.Scale;
begin
  Memo1.StyleLookup := 'memolabelstyle';
  pnlDesk.Scale.X := frmMain.tbScale.Value / 100;
  pnlDesk.Scale.Y := pnlDesk.Scale.X;
  pnlDesk.RecalcSize;
end;

procedure TfrmBafDialog.SetPosition(AParentForm: TForm);
var
  LLeft, LTop: integer;
begin
  if AParentForm = nil then
    AParentForm := frmMain;
  LLeft := round(AParentForm.ClientToScreen(PointF(0, 0)).X);
  LTop := round(AParentForm.ClientToScreen(PointF(0, 0)).Y);
  Left := (LLeft + AParentForm.Width div 2) - (Width div 2);
  Top := (LTop + AParentForm.Height div 2) - (Height div 2);
//  Left := (AParentForm.Left + AParentForm.Width div 2) - (Width div 2);
//  Top := (AParentForm.Top + AParentForm.Height div 2) - (Height div 2);
end;

class procedure TfrmBafDialog.ShowMessage(ATitle, AMessage: string;
  AParentForm: TForm);
var
  LDialog: TfrmBafDialog;
begin
  LDialog := TfrmBafDialog.Create(nil);
  try
    LDialog.Caption := ATitle;
    LDialog.Memo1.Lines.Text := AMessage;
    LDialog.Memo1.StyleLookup := 'memolabelstyle';
    LDialog.Memo1.ShowScrollBars := false;
    LDialog.pnlYesNo.Visible := false;
    LDialog.pnlProgress.Visible := false;
    LDialog.pnlProgress2.Visible := false;
    LDialog.Scale;
    LDialog.CalcSize;
    LDialog.SetPosition(AParentForm);
    LDialog.ShowModal;
  finally
    LDialog.Free;
  end;
end;

end.
