unit foBafDbDebug;

// this code is under the BAF fair use license (BFUL) - https://bafbal.de/index.php?title=Bful
// for debugging DB commands

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.StdCtrls,
  FMX.Controls.Presentation, FMX.ScrollBox, FMX.Memo, FMX.Memo.Types;

type
  TfrmBafDbDebug = class(TForm)
    memLog: TMemo;
    cbLog: TCheckBox;
    btnExec: TButton;
    btnSkip: TButton;
    pnlDesk: TPanel;
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FPosAusIni: boolean;
  public
  end;

var
  frmBafDbDebug: TfrmBafDbDebug;

implementation

{$R *.fmx}

uses dmMain, uBafFmxUtils;

procedure TfrmBafDbDebug.FormDestroy(Sender: TObject);
begin
  BafFormPos2Ini(Self, dataMain.UserIni, CAT_DEBUG_DB);
  dataMain.UserIni.UpdateFile;
end;

procedure TfrmBafDbDebug.FormShow(Sender: TObject);
begin
  if not FPosAusIni then begin
    BafIni2FormPos(Self, dataMain.UserIni, CAT_DEBUG_DB, 10, 10, 400, 300);
    FPosAusIni := true;
  end;
  Caption := CAT_DEBUG_DB;
end;

end.
