unit foBafCommandWizard;

// this code is under the BAF fair use license (BFUL) - https://bafbal.de/index.php?title=Bful
// selecting pre-defined commands

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, data.DB,
  FMX.Controls.Presentation, FMX.StdCtrls, FMX.Layouts, FMX.ListBox, FMX.Edit;

type
  TfrmCommandWizard = class(TForm)
    pnlDesk: TPanel;
    btnOk: TButton;
    btnAbort: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    ListBox1: TListBox;
    procedure FormShow(Sender: TObject);
    procedure ListBox1Change(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    class function Execute(var ASelCommand, ANewName: string): boolean;
  end;

implementation

{$R *.fmx}

uses foMain, foBafCode, dmMain, uBafTypes;

{ TfrmCommandWizard }

class function TfrmCommandWizard.Execute(var ASelCommand,
  ANewName: string): boolean;
var
  frmCommandWizard: TfrmCommandWizard;
  ix: integer;
begin
  frmCommandWizard := TfrmCommandWizard.Create(nil);
  try
    result := frmCommandWizard.ShowModal = mrOk;
    if result then begin
      ix := frmCommandWizard.ListBox1.ItemIndex;
      if ix >= 0 then
        ASelCommand := frmCommandWizard.ListBox1.Items[ix]
      else
        result := false;
      ANewName := Trim(frmCommandWizard.Edit1.Text);
      if ANewName = '' then
        result := false;
    end;
  finally
    frmCommandWizard.Free;
  end;
end;

procedure TfrmCommandWizard.FormShow(Sender: TObject);
var
  LSql: string;
  LDataset: TDataset;
begin
  pnlDesk.Scale.X := frmMain.tbScale.Value / 100;
  pnlDesk.Scale.Y := pnlDesk.Scale.X;
  Width := trunc(385 * pnlDesk.Scale.X) + 11;
  Height := trunc(392 * pnlDesk.Scale.X) + 31;
  Left := frmBafCode.Left + 20;
  Top := frmBafCode.Top + 20;
  LSql := dataMain.GetSqlTextFromDevtext('_code_wizard_names', '');
  if LSql = '' then
    LSql := 'select name from sys_devtext where parent = '
       + QuotedStr('DBA8A5C1-3723-446F-A3A0-6A0BB0828048') + ' order by name';
  dataMain.QueryPrepare(dataMain.DefaultCon, CMD_WIZ, LSql);
  LDataset := dataMain.QueryOpen(dataMain.DefaultCon, CMD_WIZ);
  while not LDataset.Eof do begin
    ListBox1.Items.Add(LDataset.Fields[0].AsString);
    LDataset.Next;
  end;
end;

procedure TfrmCommandWizard.ListBox1Change(Sender: TObject);
begin
  btnOk.Enabled := (ListBox1.Items[ListBox1.ItemIndex] <> '');
end;

end.



