unit foBafCodeWizVlWiz;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, DB,
  FMX.Controls.Presentation, FMX.StdCtrls, FMX.Memo.Types, System.Rtti,
  FMX.Grid.Style, FMX.Grid, FMX.ScrollBox, FMX.Memo, FMX.EditBox, FMX.SpinBox,
  FMX.ListBox, FMX.Edit, FMX.TabControl, uBafPage, uBafInterpreter,
  System.Math, contnrs, uBafComboHelper, uBafTypes;

type
  TfrmWizVlWiz = class(TForm)
    pnlMain: TPanel;
    pnlGrid: TPanel;
    Splitter2: TSplitter;
    tcWizVlWiz: TTabControl;
    tabVL: TTabItem;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    edtName: TEdit;
    edtCaption: TEdit;
    GroupBox1: TGroupBox;
    cbBtnHistory: TCheckBox;
    cbBtnPdf: TCheckBox;
    cbBtnXls: TCheckBox;
    cmbLineType: TComboBox;
    Label20: TLabel;
    cbGridReadOnly: TCheckBox;
    TabCell: TTabItem;
    Label2: TLabel;
    edtCellFieldName: TEdit;
    edtCellHintFieldName: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    cmbCellType: TComboBox;
    cmbCellAlign: TComboBox;
    Label5: TLabel;
    Label6: TLabel;
    cmbLookup: TComboBox;
    cbNoData: TCheckBox;
    cbReadOnly: TCheckBox;
    cmbCharacterType: TComboBox;
    Label9: TLabel;
    edtCharsIgnore: TEdit;
    Label10: TLabel;
    cmbNV: TComboBox;
    edtNV: TEdit;
    btnGuid: TButton;
    btnFnd: TButton;
    lblLength: TLabel;
    sbLength: TSpinBox;
    cmbLdLs: TComboBox;
    btnPval: TButton;
    tabCode: TTabItem;
    btnRestart: TButton;
    Label19: TLabel;
    memWizGridWizCode: TMemo;
    btnAddPage: TButton;
    edtCellCaption: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    lblColumn: TLabel;
    sbColWidth: TSpinBox;
    Label15: TLabel;
    Label16: TLabel;
    sbColStretch: TSpinBox;
    btnCol0: TButton;
    btnCol10P: TButton;
    btnCol50P: TButton;
    btnCol10M: TButton;
    btnCol200P: TButton;
    lblRow: TLabel;
    btnDeleteRow: TButton;
    Label1: TLabel;
    Label11: TLabel;
    sbColCount: TSpinBox;
    sgColumns: TStringGrid;
    IntegerColumn1: TIntegerColumn;
    IntegerColumn2: TIntegerColumn;
    IntegerColumn3: TIntegerColumn;
    btnWidth0: TButton;
    btnWidth10P: TButton;
    btnWidth50P: TButton;
    btnWidth10M: TButton;
    btnWidth200P: TButton;
    lblHfColSpan: TLabel;
    sbColSpan: TSpinBox;
    procedure FormCreate(Sender: TObject);
    procedure sbColCountChange(Sender: TObject);
    procedure sgColumnsEditingDone(Sender: TObject; const ACol, ARow: Integer);
    procedure btnWidth0Click(Sender: TObject);
    procedure cmbLineTypeChange(Sender: TObject);
    procedure cbBtnHistoryChange(Sender: TObject);
    procedure edtCellFieldNameChange(Sender: TObject);
    procedure cmbCellTypeChange(Sender: TObject);
    procedure edtCaptionChange(Sender: TObject);
    procedure cmbLdLsChange(Sender: TObject);
    procedure btnGuidClick(Sender: TObject);
    procedure btnCol0Click(Sender: TObject);
    procedure tabVLClick(Sender: TObject);
    procedure btnDeleteRowClick(Sender: TObject);
    procedure tabCodeClick(Sender: TObject);
  protected
    FCellLock: boolean;
    FCell: TBafSgCell;
    FHelper: TBafComboHelper;
    FDataset: TDataSet;
    procedure PageRefresh;
    procedure PageSelectCell(const Sender: TBafPageParents);
    procedure Cell2Form(ACell: TBafSgCell);
    procedure InitLookup;
    procedure RefreshLookup;
    function GetCode: string;
  private
    FGrid: TBafSimpleGrid;
    FInter: TBafInterpreter;
    FWizSql: string;
    FCol, FRow: integer;
    procedure InitInterpreter;
    procedure InterNeedCommand(AInter: TBafInterpreter; AName: string; ACode: TStrings);
    procedure InterNeedInfo(AInter: TBafInterpreter; AName, AParam: string; var AInfo: string);
  public
    class function GetVlCode(AGrid, AParams: TStringGrid;
        AWizSql, AConName: string): string;
    procedure Init(AGrid, AParams: TStringGrid; AWizSql, AConName: string);
  end;

var
  frmWizVlWiz: TfrmWizVlWiz;

implementation

{$R *.fmx}

uses dmMain, uBafInterpreterModuleList, uBafDataCache, foBafDialog, uOsStuff;

{ TfrmWizVlWiz }

procedure TfrmWizVlWiz.btnCol0Click(Sender: TObject);
begin
  if Sender = btnCol0 then
    sbColWidth.Value := 0
  else if Sender = btnCol10P then
    sbColWidth.Value := sbColWidth.Value + 10
  else if Sender = btnCol10M then
    sbColWidth.Value := sbColWidth.Value - 10
  else if Sender = btnCol50P then
    sbColWidth.Value := sbColWidth.Value + 50
  else if Sender = btnCol200P then
    sbColWidth.Value := sbColWidth.Value + 200;
end;

procedure TfrmWizVlWiz.btnDeleteRowClick(Sender: TObject);
begin
  if TfrmBafDialog.DialogYesNow('Confirmation', 'Delete this row', Self) then begin
    FGrid.DeleteRow(FRow);
    FGrid.SelectedRow := FRow - 1;
    PageRefresh;
  end;
end;

procedure TfrmWizVlWiz.btnGuidClick(Sender: TObject);
begin
  if Sender = btnGuid then
    edtNV.Text := '$GUID()'
  else if Sender = btnFnd then
    edtNV.Text := Format('$FND(s,%s)', [edtCellFieldName.Text])
  else if Sender = btnPVal then
    edtNV.Text := Format('$PVAL(vl,%s)', [edtCellFieldName.Text])
  ;
end;

procedure TfrmWizVlWiz.btnWidth0Click(Sender: TObject);
var
  LCol, LRow: integer;
begin
  LCol := Max(sgColumns.Col, 1);
  LRow := Max(sgColumns.Row, 0);
  if Sender = btnWidth0 then
    sgColumns.Cells[LCol, LRow] := '0'
  else if Sender = btnWidth10P then
    sgColumns.Cells[LCol, LRow]
      := IntToStr(StrToIntDef(sgColumns.Cells[LCol, LRow], 0) + 10)
  else if Sender = btnWidth10M then
    sgColumns.Cells[LCol, LRow]
      := IntToStr(StrToIntDef(sgColumns.Cells[LCol, LRow], 0) - 10)
  else if Sender = btnWidth50P then
    sgColumns.Cells[LCol, LRow]
      := IntToStr(StrToIntDef(sgColumns.Cells[LCol, LRow], 0) + 50)
  else if Sender = btnWidth200P then
    sgColumns.Cells[LCol, LRow]
      := IntToStr(StrToIntDef(sgColumns.Cells[LCol, LRow], 0) + 200);
  case sgColumns.Col of
    1: FGrid.Columns.Items[LRow].Width := StrToInt(sgColumns.Cells[LCol, LRow]);
    2: FGrid.Columns.Items[LRow].Stretch := StrToInt(sgColumns.Cells[LCol, LRow]);
  end;
  FGrid.Columns.GridHeaderLineBreak;
  PageRefresh;
end;

procedure TfrmWizVlWiz.cbBtnHistoryChange(Sender: TObject);
var
  s: string;
begin
  if cbBtnXls.IsChecked then
    s := s + 'X';
  if cbBtnPdf.IsChecked then
    s := s + 'Y';
  if cbBtnHistory.IsChecked then
    s := s + 'H';
  FGrid.Parents.Segment.Buttons := s;
  if (s <> '') and (FGrid.Parents.Segment.Header = '') then
    FGrid.Parents.Segment.Header := ' ';
end;

procedure TfrmWizVlWiz.Cell2Form(ACell: TBafSgCell);
begin
  FCellLock := true;
  try
    FCell := ACell;
    FCell.Visible := true;
    FCol := FCell.Parents.Column.Index;
    lblColumn.Text := 'column ' + IntToStr(FCol + 1);
    FRow := FCell.Parents.Row.RowIndex;
    lblRow.Text := 'row ' + IntToStr(FRow + 1);
    edtCellFieldName.Text := ACell.DataFieldName;
    sbColWidth.Value := FCell.Parents.Column.Width;
    sbColStretch.Value := FCell.Parents.Column.Stretch;
    if (ACell.DataFieldName = '') and (ACell.Text <> '') then begin
      edtCellCaption.Text := ACell.Text;
      edtCellFieldName.Enabled := false;
      edtCellCaption.Enabled := true;
    end
    else if (ACell.DataFieldName = '') and (ACell.Text = '') then begin
      edtCellCaption.Text := '';
      edtCellFieldName.Enabled := true;
      edtCellCaption.Enabled := true;
    end
    else begin
      edtCellCaption.Text := '';
      edtCellFieldName.Enabled := true;
      edtCellCaption.Enabled := false;
    end;
    edtCellHintFieldName.Text := ACell.DataHintFieldName;
    cmbCellType.ItemIndex
        := cmbCellType.Items.IndexOf(BafGetCellTypeName(ACell.CellType));
    cmbCellAlign.ItemIndex
        := cmbCellAlign.Items.IndexOf(BafGetAlignName(ACell.Alignment));
    InitLookup;
    cbNoData.IsChecked := ACell.NoData;
    cbReadOnly.IsChecked := ACell.ReadOnly;
    sbLength.Value := ACell.MaxLength;
    sbColSpan.Value := ACell.ColSpan;
    case FCell.CharCase of
      TEditCharCase.ecLowerCase: cmbCharacterType.ItemIndex := 0;
      TEditCharCase.ecUpperCase: cmbCharacterType.ItemIndex := 2;
      else
        cmbCharacterType.ItemIndex := 1;
    end;
    edtCharsIgnore.Text := ACell.CharsIgnore;
    cmbNV.ItemIndex := integer(FCell.NullValueAction);
    edtNV.Text := FCell.NullValue;
  finally
    FCellLock := false;
  end;
end;

procedure TfrmWizVlWiz.cmbCellTypeChange(Sender: TObject);
var
  LCombo: TComboBox;
  s, LLookup: string;
begin
  if FCellLock then
    exit;
  LCombo := (Sender as TComboBox);
  if LCombo.ItemIndex >= 0 then
    s := LCombo.Items[LCombo.ItemIndex];
  if Sender = cmbCellType then begin
    FCell.CellType := BafGetCellType(s);
    InitLookup;
  end
  else if Sender = cmbCellAlign then
    FCell.Alignment := BafGetAlign(s, taLeftJustify)
  else if Sender = cmbLookup then begin
    LLookup := FHelper.GetGuid(cmbLookup);
    s := IntToStr(FCol + 1);
    if cmbLdLs.ItemIndex = 0 then begin
      FCell.LookupHelper := gvBafDataCache.Lookup[LLookup];
      FCell.LookupCmd := 'ld' + s + '=' + LLookup;
    end
    else begin
      FCell.LookupHelper := gvBafDataCache.Special[LLookup];
      FCell.LookupCmd := 'ls' + s + '=' + LLookup;
    end;
  end
  else if Sender = cmbCharacterType then begin
    case (s + ' ')[1] of
      'l': FCell.CharCase := TEditCharCase.ecLowerCase;
      'u': FCell.CharCase := TEditCharCase.ecUpperCase;
      else
        FCell.CharCase := TEditCharCase.ecNormal;
    end;
  end

  ;
  PageRefresh;
end;

procedure TfrmWizVlWiz.cmbLdLsChange(Sender: TObject);
begin
  case cmbLdLs.ItemIndex of
    0: cmbLookup.Hint := 'LookupData';
    1: cmbLookup.Hint := 'LookupSpecial';
  end;
  RefreshLookup;
end;

procedure TfrmWizVlWiz.cmbLineTypeChange(Sender: TObject);
var
  s: string;
begin
  s := copy(cmbLineType.Items[cmbLineType.ItemIndex], 1, 2);
  FGrid.Columns.LineType := BafGetGridLineType(s);
  FGrid.Columns.GridHeaderLineBreak;
  PageRefresh;
end;

procedure TfrmWizVlWiz.edtCaptionChange(Sender: TObject);
begin
  if Sender = edtCaption then
    FGrid.Parents.Segment.Header := edtCaption.Text

  ;
end;

procedure TfrmWizVlWiz.edtCellFieldNameChange(Sender: TObject);
var
  LField: TField;
begin
  if FCellLock then
    exit;
  if Sender = edtCellFieldName then begin
    FCell.DataFieldName := edtCellFieldName.Text;
    LField := FDataset.FindField(edtCellFieldName.Text);
    if Assigned(LField) then
      FCell.Text := LField.AsString
    else
      FCell.Text := '';
    edtCellFieldName.Enabled := true;
    edtCellCaption.Enabled := false;
  end
  else if Sender = edtCellCaption then begin
    FCell.Text := edtCellCaption.Text;
    if FCell.Text <> '' then
      cbReadOnly.IsChecked := true;
    edtCellFieldName.Enabled := false;
    edtCellCaption.Enabled := true;
  end
  else if Sender = edtCellHintFieldName then begin
    FCell.DataHintFieldName := edtCellHintFieldName.Text;
    LField := FDataset.FindField(edtCellHintFieldName.Text);
    if Assigned(LField) then
      FCell.Hint := LField.AsString
    else
      FCell.Hint := FCell.DataHintFieldName;
  end
  else if Sender = cbNoData then
    FCell.NoData := cbNoData.IsChecked
  else if Sender = cbReadOnly then begin
    FCell.ReadOnly := cbReadOnly.IsChecked;
    if not FCell.ReadOnly and (edtCaption.Text = '') then
      edtCellFieldName.Enabled := true;
  end
  else if Sender = edtCharsIgnore then
    FCell.CharsIgnore := edtCharsIgnore.Text
  else if Sender = sbColWidth then
    FCell.Parents.Column.Width := sbColWidth.Value
  else if Sender = sbColStretch then
    FCell.Parents.Column.Stretch := sbColStretch.Value
  else if Sender = edtNV then
    FCell.NullValue := edtNV.Text
  else if Sender = cmbNV then
    FCell.NullValueAction := TBafNullValueAction(cmbNV.ItemIndex)
  else if Sender = sbLength then
    FCell.MaxLength := round(sbLength.Value)
  else if Sender = sbColSpan then
    FCell.ColSpan := round(sbColSpan.Value)


  ;
  FGrid.Columns.GridHeaderLineBreak;
  PageRefresh;
end;

procedure TfrmWizVlWiz.FormCreate(Sender: TObject);
begin
  InitInterpreter;
end;

function TfrmWizVlWiz.GetCode: string;
var
  sl: TStringList;
  i, LRow: integer;
  s: string;
  LCell: TBafSgCell;

  procedure lokVlSeg;
  var
    LCol: integer;
    LColumn: TBafSgColumn;
  begin
    result := '#vl_seg   clt=' + copy(cmbLineType.Items[cmbLineType.ItemIndex], 1, 2)
        + '   n=' + edtName.Text + '   cc=' + sbColCount.Text;
    if cbBtnXls.IsChecked then
      s := s + 'X';
    if cbBtnPdf.IsChecked then
      s := s + 'Y';
    if cbBtnHistory.IsChecked then
      s := s + 'H';
    if edtCaption.Text <> '' then
      result := result + '   c="' + edtCaption.Text + '"'
    else if s <> '' then
      result := result + '   c=" "';
    if s <> '' then
      result := result + '   b=' + s;
    for LCol := 0 to FGrid.Columns.Count - 1 do begin
      s := IntToStr(LCol + 1);
      LColumn := FGrid.Columns.Items[LCol];
      result := result + '   w' + s + '=' + FormatFloat('0', LColumn.Width);
      if LColumn.Stretch > 0.5 then
        result := result + '   wst' + s + '=' + FormatFloat('0', LColumn.Stretch);
    end;
    if cbGridReadOnly.IsChecked then
      result := result + '   ro=Y';
    result := result + #13#10;
  end; // procedure lokVlSeg

  procedure lokRow;
  var
    LCol: integer;
  begin
    result := result + '#vl_line';
    for LCol := 0 to FGrid.Columns.Count - 1 do begin
      s := IntToStr(LCol + 1);
      LCell := FGrid.Cells[rtData, LCol, LRow];
      if LCell.DataFieldName <> '' then begin
        result := result + '   f' + s + '=' + LCell.DataFieldName;
        if LCell.ReadOnly then
          result := result + '   ro' + s + '=Y';
      end
      else if LCell.Text <> '' then
        result := result + '   c' + s + '=' + LCell.Text;
      if LCell.DataHintFieldName <> '' then
        result := result + '   h' + s + '=' + LCell.DataHintFieldName;
      if LCell.ColSpan > 1 then
        result := result + '   cs' + s + '=' + IntToStr(LCell.ColSpan);
      if LCell.CellType <> ctText then
        result := result + '   y' + s + '=' + BafGetCellTypeName(LCell.CellType);
      if LCell.CellType in [ctLookup, ctLookupText] then
        result := result + '   ' + LCell.LookupCmd;
      if LCell.MaxLength > 0 then
        result := result + '   l' + s + '=' + IntToStr(LCell.MaxLength);
      if LCell.Alignment <> taLeftJustify then
        result := result + '   l' + s + '=' + BafGetAlignName(LCell.Alignment);
      if LCell.NoData then
        result := result + '   nd' + s + '=Y';
      if LCell.CharsIgnore <> '' then
        result := result + '   ci' + s + '="' + LCell.CharsIgnore + '"';
      if LCell.NullValueAction <> nvNone then
        result := result + '   ' + BafGetNvaName(LCell.NullValueAction)
            + s + '=' + LCell.NullValue;
    end;
    result := result + #13#10;
  end; // procedure lokRow

begin
  lokVlSeg;
  for LRow := 0 to FGrid.RowCount(rtData) - 1 do
    lokRow;

  sl := TStringList.Create;
  try
    sl.Text := FWizSql;
    for i := 0 to sl.Count - 1 do
      result := result + '#sql ' + sl[i] + #13#10;
  finally
    sl.Free;
  end;

  result := result + '#vl_data   q=sql   t=   ' + #13#10;
// function TfrmWizVlWiz.GetCode
end;

class function TfrmWizVlWiz.GetVlCode(AGrid, AParams: TStringGrid; AWizSql,
  AConName: string): string;
var
  sl, sl2: TStringList;
  LLine: string;
  i, LRow: integer;

  procedure lokCheckInsert(ACol: integer; APre, AAdd: string);
  begin
    if AGrid.Cells[ACol, LRow] <> '' then
      LLine := LLine + '   ' + APre + '=' + AGrid.Cells[ACol, LRow] + AAdd;
  end;

begin
  sl := TStringList.Create;
  try
    sl.Text := '#vl_seg   cc=2   clt=ss   w1=100   w2=300   wst2=300  n=vl';
    for LRow := 0 to AGrid.RowCount - 1 do begin
      if AGrid.Cells[0, LRow] = 'True' then begin
        LLine := '#vl_line   c1="' + AGrid.Cells[2, LRow]
            + '"   f2=' + AGrid.Cells[1, LRow];
        lokCheckInsert(5, 'l', '');
        lokCheckInsert(6, 'y', '');
        if AGrid.Cells[8, LRow] = 'True' then
            LLine := LLine + '   ro2=Y';
        sl.Add(LLine);
      end;
    end;

    sl2 := TStringList.Create;
    try
      sl2.Text := AWizSql;
      for i := 0 to sl2.Count - 1 do
        sl.Add('#sql ' + sl2[i]);
    finally
      sl2.Free;
    end;

    LLine := '#vl_data   q=sql   t=   ';
    for LRow := 0 to AParams.RowCount - 1 do
      LLine := LLine + AParams.Cells[0, LRow] + '=' + AParams.Cells[1, LRow] + '   ';
    if (AConName <> '') and (AConName <> 'default') then
      LLine := LLine + '   db=' + AConName;
    sl.Add(LLine);

  finally
    result := sl.Text;
    sl.Free;
  end;
// class function TfrmWizVlWiz.GetVlCode
end;

procedure TfrmWizVlWiz.Init(AGrid, AParams: TStringGrid; AWizSql, AConName: string);
var
  LCode, LBafConName, LName: string;
  LComp: TComponent;
begin
  FWizSql := AWizSql;
  LCode := '#rights  n=frm   r_user=w' + #13#10
     + '#frm  y=page  ' + #13#10
     + '#page   y=dashhor' + #13#10
     + '#prim  as=Y' + #13#10
     + '#cat  as=Y      c=Preview' + #13#10
     + GetVlCode(AGrid, AParams, AWizSql, AConName) + #13#10
     + '#page_ready' + #13#10;
  FInter.Execute(LCode);
  LComp := FInter.GetFrmComponent('page');
  TBafPage(LComp).OnSelectCell := PageSelectCell;
  FGrid := nil;
  if Assigned(LComp) and (LComp is TBafPage) then
    FGrid := TBafPage(LComp).PrimaryDivs.Items[0].Categories.Items[0].Segments.Items[0].Grid;
  LBafConName := FGrid.Parents.Segment.BafConName[0];
  LName := FInter.Name + '~' + LBafConName;
  FDataSet := dataMain.QueryOpen(LBafConName, LName);

  sbColCount.Value := 2;
  edtName.Text := 'vl';
  tcWizVlWiz.ActiveTab := tabVL;
//  tabColumnClick(nil);
//  RefreshColumns;
end;

procedure TfrmWizVlWiz.InitInterpreter;
begin
  FInter := TBafInterpreter.Create(itSrvProc);
  FInter.Inter := FInter;
  FInter.Name := 'WizGridWiz';
  FInter.OnNeedCommand := InterNeedCommand;
  FInter.OnNeedInfo := InterNeedInfo;
//  FInter.OnLog := InterLog;
  FInter.ParentPanel := pnlGrid;
  TBafInterpreterModuleList.CreateModule(FInter);
end;

procedure TfrmWizVlWiz.InitLookup;
var
  s: string;
  p: integer;
begin
  cmbLdLs.Visible := FCell.CellType in [ctLookup, ctLookupText];
  cmbLookup.Visible := FCell.CellType in [ctLookup, ctLookupText];
  lblLength.Visible := not (FCell.CellType in [ctLookup, ctLookupText]);
  sbLength.Visible := not (FCell.CellType in [ctLookup, ctLookupText]);
  if FCell.CellType in [ctLookup, ctLookupText] then begin
    s := FCell.LookupCmd;
    p := Pos('=', s);
    if copy(s, 1, p - 1) = 'ls' then
      cmbLdLs.ItemIndex := 1
    else
      cmbLdLs.ItemIndex := 0;
    RefreshLookup;
    s := copy(s, p + 1, MaxInt);
    FHelper.SetGuid(cmbLookup, s);
  end;
end;

procedure TfrmWizVlWiz.InterNeedCommand(AInter: TBafInterpreter; AName: string;
  ACode: TStrings);
begin
  AName := AnsiLowerCase(AName);
  if not dataMain.GetCommand(AName, ACode) then
//    InterLog(nil, 'E', 'Kommando nicht gefunden: ' + AName);
end;

procedure TfrmWizVlWiz.InterNeedInfo(AInter: TBafInterpreter; AName,
  AParam: string; var AInfo: string);
begin
  AName := AnsiLowerCase(AName);
  if AName = 'usrid' then AInfo := dataMain.UserGuid
  else if AName = 'rightusrid' then AInfo := dataMain.RightUserId
  else if AName = 'root' then AInfo := dataMain.Root
  else if AName = 'usrroot' then AInfo := dataMain.UserRoot
  else if AName = 'usrini' then AInfo := dataMain.UserIni.ReadString(CAT_USRDATA, AParam, '')
  else if AName = 'ini' then AInfo := dataMain.Ini.ReadString(CAT_DATA, AParam, '')
  ;
end;

procedure TfrmWizVlWiz.PageRefresh;
var
  LPage: TBafPage;
begin
  LPage := FGrid.Parents.Page;
  LPage.SetAutoSize;
  LPage.RecalcCells;
  LPage.Resize;
end;

procedure TfrmWizVlWiz.PageSelectCell(const Sender: TBafPageParents);
begin
  if Assigned(Sender.Cell) then
    Cell2Form(Sender.Cell);
end;

procedure TfrmWizVlWiz.RefreshLookup;
begin
  case cmbLdLs.ItemIndex of
    0: FHelper := gvBafDataCache.Special['system_lookup_lists'];
    1: FHelper := gvBafDataCache.Special['system_special_lists'];
  end;
  FHelper.FillComboBox(cmbLookup);
end;

procedure TfrmWizVlWiz.sbColCountChange(Sender: TObject);
var
  LRow: integer;
begin
  sgColumns.RowCount := round(sbColCount.Value);
  for LRow := 0 to sgColumns.RowCount - 1 do begin
    sgColumns.Cells[0, LRow] := IntToStr(LRow + 1);
    while LRow >= FGrid.Columns.Count do begin
      FGrid.Columns.Add.Width := 100;
    end;
    sgColumns.Cells[1, LRow] := IntToStr(round(FGrid.Columns.Items[LRow].Width));
    sgColumns.Cells[2, LRow] := IntToStr(round(FGrid.Columns.Items[LRow].Stretch));
  end;
  while FGrid.Columns.Count > round(sbColCount.Value) do
    FGrid.Columns.Delete(FGrid.Columns.Count - 1);
  FGrid.Columns.GridHeaderLineBreak;
  PageRefresh;
  sgColumns.Col := 1;
  sgColumns.Row := round(sbColCount.Value) - 1;
  if sgColumns.CanFocus then
    sgColumns.SetFocus;
end;

procedure TfrmWizVlWiz.sgColumnsEditingDone(Sender: TObject; const ACol,
  ARow: Integer);
begin
  case ACol of
    1: FGrid.Columns.Items[ARow].Width := StrToInt(sgColumns.Cells[ACol, ARow]);
    2: FGrid.Columns.Items[ARow].Stretch := StrToInt(sgColumns.Cells[ACol, ARow]);
  end;
  FGrid.Columns.GridHeaderLineBreak;
  PageRefresh;
end;

procedure TfrmWizVlWiz.tabCodeClick(Sender: TObject);
begin
  memWizGridWizCode.Lines.Text := GetCode;
  Clipboard.AsText := memWizGridWizCode.Lines.Text;
end;

procedure TfrmWizVlWiz.tabVLClick(Sender: TObject);
var
  LRow: integer;
begin
  for LRow := 0 to sgColumns.RowCount - 1 do begin
    sgColumns.Cells[1, LRow] := IntToStr(round(FGrid.Columns.Items[LRow].Width));
    sgColumns.Cells[2, LRow] := IntToStr(round(FGrid.Columns.Items[LRow].Stretch));
  end;
end;

end.
