unit foBafCodeWizGridWiz;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, StrUtils,
  FMX.Controls.Presentation, FMX.StdCtrls, FMX.Memo.Types, System.Rtti,
  FMX.Grid.Style, FMX.EditBox, FMX.SpinBox, FMX.Grid, FMX.Edit, FMX.ScrollBox,
  FMX.Memo, FMX.TabControl, uBafPage, uBafInterpreter, System.Math, contnrs,
  FMX.Layouts, FMX.ListBox, FMX.ComboEdit, uBafComboHelper;

type
  TfrmWizGridWiz = class(TForm)
    pnlMain: TPanel;
    tcWizGridWiz: TTabControl;
    tabGrid: TTabItem;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    sbWizGridWizHeaderRowCount: TSpinBox;
    Label18: TLabel;
    sbWizGridWizFooterRowCount: TSpinBox;
    sbWizGirdWizHeaderRow: TSpinBox;
    btnWizGridWizHeaderClear: TButton;
    btnWizGridWizHeaderFieldNames: TButton;
    tabColumn: TTabItem;
    tabCode: TTabItem;
    btnRestart: TButton;
    Label19: TLabel;
    memWizGridWizCode: TMemo;
    pnlGrid: TPanel;
    Panel1: TPanel;
    Label1: TLabel;
    lbColumns: TListBox;
    Splitter1: TSplitter;
    Panel2: TPanel;
    Label2: TLabel;
    edtCellFieldName: TEdit;
    edtCellHintFieldName: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    cmbCellType: TComboBox;
    cmbCellAlign: TComboBox;
    Label5: TLabel;
    Label6: TLabel;
    cmbLookup: TComboBox;
    sbWidth: TSpinBox;
    sbWidthStretch: TSpinBox;
    Label7: TLabel;
    Label8: TLabel;
    cbNoData: TCheckBox;
    cbReadOnly: TCheckBox;
    cmbCharacterType: TComboBox;
    Label9: TLabel;
    edtCharsIgnore: TEdit;
    Label10: TLabel;
    cmbNV: TComboBox;
    edtNV: TEdit;
    btnGuid: TButton;
    btnFnd: TButton;
    lblLength: TLabel;
    sbLength: TSpinBox;
    btn0: TButton;
    btn30: TButton;
    btn50P: TButton;
    btn100P: TButton;
    Splitter2: TSplitter;
    cmbLdLs: TComboBox;
    Splitter3: TSplitter;
    Panel4: TPanel;
    Label11: TLabel;
    lbHf: TListBox;
    edtHfCaption: TEdit;
    lblHfCaption: TLabel;
    edtHfHint: TEdit;
    lblHfHint: TLabel;
    sbHfColSpan: TSpinBox;
    lblHfColSpan: TLabel;
    cmbHfType: TComboBox;
    cmbHfAlign: TComboBox;
    lblHfType: TLabel;
    lblHfAlign: TLabel;
    edtHfCmd: TEdit;
    lblHfCmd: TLabel;
    btnHfCount: TButton;
    btnHfSum: TButton;
    btnHfMin: TButton;
    btnHfMax: TButton;
    btnHfAvg: TButton;
    btnHfMed: TButton;
    Panel3: TPanel;
    Panel5: TPanel;
    Label12: TLabel;
    Splitter4: TSplitter;
    Label13: TLabel;
    edtName: TEdit;
    Label14: TLabel;
    edtCaption: TEdit;
    GroupBox1: TGroupBox;
    cbBtnActive: TCheckBox;
    cbBtnInactive: TCheckBox;
    cbBtnHistory: TCheckBox;
    cbBtnPdf: TCheckBox;
    cbBtnXls: TCheckBox;
    cbBtnFilter: TCheckBox;
    cmbLineType: TComboBox;
    Label20: TLabel;
    sbFixedColumnsCount: TSpinBox;
    Label21: TLabel;
    btnPval: TButton;
    cbGridReadOnly: TCheckBox;
    btnAddPage: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnRestartClick(Sender: TObject);
    procedure sbWizGridWizHeaderRowCountChange(Sender: TObject);
    procedure btnWizGridWizHeaderClearClick(Sender: TObject);
    procedure btnWizGridWizHeaderFieldNamesClick(Sender: TObject);
    procedure lbColumnsChange(Sender: TObject);
    procedure cmbCellTypeChange(Sender: TObject);
    procedure cbNoDataChange(Sender: TObject);
    procedure btn0Click(Sender: TObject);
    procedure cmbNVChange(Sender: TObject);
    procedure cmbLdLsChange(Sender: TObject);
    procedure tabColumnClick(Sender: TObject);
    procedure lbHfChange(Sender: TObject);
    procedure edtHfCaptionChange(Sender: TObject);
    procedure btnHfCountClick(Sender: TObject);
    procedure tabCodeClick(Sender: TObject);
    procedure cbGridReadOnlyChange(Sender: TObject);
    procedure btnAddPageClick(Sender: TObject);
    procedure cmbLineTypeChange(Sender: TObject);
  protected
    FColLock: boolean;
    FColumn: TBafSgColumn;
    FHelper: TBafComboHelper;
    FFooter: boolean;
    FHfRow: integer;
    FHfBafRow: TBafSgRow;
    procedure PageRefresh;
    procedure RefreshColumns;
    procedure Column2Form(AColumn: TBafSgColumn);
    procedure RefreshLookup;
    procedure InitLookup;
    procedure HfValues;
    function GetCode: string;
  private
    FGrid: TBafSimpleGrid;
    FInter: TBafInterpreter;
    FWizSql:  string;
    FWizDB:  string;
    procedure InitInterpreter;
    procedure InterNeedCommand(AInter: TBafInterpreter; AName: string; ACode: TStrings);
    procedure InterNeedInfo(AInter: TBafInterpreter; AName, AParam: string; var AInfo: string);
    procedure PageSelectCell(const Sender: TBafPageParents);
    procedure PageResizeCell(const Sender: TBafPageParents);
  public
    class function GetGridCode(AGrid, AParams: TStringGrid;
        AWizSql, AWizDb, AGridSeg: string): string;
    procedure Init(AGrid, AParams: TStringGrid; AWizSql, AWizDb: string);
  end;

var
  frmWizGridWiz: TfrmWizGridWiz;

implementation

{$R *.fmx}

uses foMain, uBafInterpreterModuleList, dmMain, uBafTypes, uBafFmxUtils,
  foBafCode, uBafDataCache, uOsStuff;

{ TfrmWizGridWiz }

procedure TfrmWizGridWiz.btnAddPageClick(Sender: TObject);
var
  LCode: string;
begin
  LCode :=  '#page   ' + #13#10
     + '#prim  as=Y' + #13#10
     + '#cat  as=Y      c=""' + #13#10;
  memWizGridWizCode.Lines.Insert(0, LCode);
  Clipboard.AsText := memWizGridWizCode.Lines.Text;
end;

procedure TfrmWizGridWiz.btnHfCountClick(Sender: TObject);
begin
  if Sender = btnHfCount then
    edtHfCmd.Text := Format('$PVAL(%s,%s,count)', [edtName.Text, edtCellFieldName.Text])
  else if Sender = btnHfSum then
    edtHfCmd.Text := Format('$PVAL(%s,%s,sum)', [edtName.Text, edtCellFieldName.Text])
  else if Sender = btnHfMin then
    edtHfCmd.Text := Format('$PVAL(%s,%s,min)', [edtName.Text, edtCellFieldName.Text])
  else if Sender = btnHfMax then
    edtHfCmd.Text := Format('$PVAL(%s,%s,max)', [edtName.Text, edtCellFieldName.Text])
  else if Sender = btnHfAvg then
    edtHfCmd.Text := Format('$PVAL(%s,%s,avg)', [edtName.Text, edtCellFieldName.Text])
  else if Sender = btnHfMed then
    edtHfCmd.Text := Format('$PVAL(%s,%s,med)', [edtName.Text, edtCellFieldName.Text])
  ;
end;

procedure TfrmWizGridWiz.btnRestartClick(Sender: TObject);
begin
  pnlMain.Parent := frmWizGridWiz;
  frmBafCode.tcWizard.ActiveTab := frmBafCode.tabWizSql;
end;

procedure TfrmWizGridWiz.btnWizGridWizHeaderClearClick(Sender: TObject);
var
  LCol, LRow: integer;
begin
  LRow := round(sbWizGirdWizHeaderRow.Value) - 1;
  for LCol := 0 to FGrid.Columns.Count - 1 do
    FGrid.Cells[rtHeader, LCol, LRow].Text := '';
  PageRefresh;
end;

procedure TfrmWizGridWiz.btnWizGridWizHeaderFieldNamesClick(Sender: TObject);
var
  LCol, LRow: integer;
begin
  LRow := round(sbWizGirdWizHeaderRow.Value) - 1;
  for LCol := 0 to FGrid.Columns.Count - 1 do
    FGrid.Cells[rtHeader, LCol, LRow].Text := frmBafCode.sgWizConfig.Cells[2, LCol];
  PageRefresh;
end;

procedure TfrmWizGridWiz.btn0Click(Sender: TObject);
begin
  if Sender = btn0 then
    sbWidth.Value := 0
  else if Sender = btn30 then
    sbWidth.Value := 30
  else if Sender = btn50P then
    sbWidth.Value := sbWidth.Value + 50
  else if Sender = btn100P then
    sbWidth.Value := sbWidth.Value + 100
  else if Sender = btnGuid then
    edtNV.Text := '$GUID()'
  else if Sender = btnFnd then
    edtNV.Text := Format('$FND(s,%s)', [FColumn.CellFieldName])
  else if Sender = btnPVal then
    edtNV.Text := Format('$PVAL(vl,%s)', [FColumn.CellFieldName])
  ;
end;

procedure TfrmWizGridWiz.cbGridReadOnlyChange(Sender: TObject);
begin
  if Sender = cbGridReadOnly then begin
    if cbGridReadOnly.IsChecked then
      FGrid.Parents.Segment.SegRight := brRead
    else
      FGrid.Parents.Segment.SegRight := brWrite;
  end
  else if Sender = sbFixedColumnsCount then
    FGrid.Columns.FixedColsCount := round(sbFixedColumnsCount.Value)

  ;
  PageRefresh;
end;

procedure TfrmWizGridWiz.cbNoDataChange(Sender: TObject);
var
  s: string;
begin
  if FColLock then
    exit;
  if Sender = cbNoData then
    FColumn.CellNoData := cbNoData.IsChecked
  else if Sender = cbReadOnly then
    FColumn.CellReadOnly := cbReadOnly.IsChecked
  else if Sender = edtCellHintFieldName then
    FColumn.CellHintFieldName := edtCellFieldName.Text
  else if Sender = edtCharsIgnore then
    FColumn.CellCharsIgnore := edtCharsIgnore.Text
  else if Sender = sbWidth then begin
    FColumn.Width := sbWidth.Value;
    s := Format('[%d] %s', [round(FColumn.Width), FColumn.CellFieldName]);
    lbColumns.Items[lbColumns.ItemIndex] := s;
  end
  else if Sender = sbWidthStretch then
    FColumn.Stretch := sbWidthStretch.Value
  else if Sender = sbLength then
    FColumn.CellMaxLength := round(sbLength.Value)
  else if Sender = edtNV then
    FColumn.SetNullValue(TBafNullValueAction(cmbNV.ItemIndex), edtNV.Text);

  ;
  if (Sender = sbWidth) or (Sender = sbWidthStretch) then
    FGrid.Columns.GridHeaderLineBreak;
  PageRefresh;
end;

procedure TfrmWizGridWiz.cmbCellTypeChange(Sender: TObject);
var
  LCombo: TComboBox;
var
  s, LLookup: string;
begin
  if FColLock then
    exit;
  LCombo := (Sender as TComboBox);
  if LCombo.ItemIndex >= 0 then
    s := LCombo.Items[LCombo.ItemIndex];
  if Sender = cmbCellType then begin
    FColumn.CellType := BafGetCellType(s);
    InitLookup;
  end
  else if Sender = cmbCellAlign then
    FColumn.CellAlignment := BafGetAlign(s, taLeftJustify)
  else if Sender = cmbLookup then begin
    LLookup := FHelper.GetGuid(cmbLookup);
    if cmbLdLs.ItemIndex = 0 then begin
      FColumn.CellLookupHelper := gvBafDataCache.Lookup[LLookup];
      FColumn.CellLookupCmd := 'ld=' + LLookup;
    end
    else begin
      FColumn.CellLookupHelper := gvBafDataCache.Special[LLookup];
      FColumn.CellLookupCmd := 'ls=' + LLookup;
    end;
  end
  else if Sender = cmbCharacterType then begin
    case (s + ' ')[1] of
      'l': FColumn.CellCharCase := TEditCharCase.ecLowerCase;
      'u': FColumn.CellCharCase := TEditCharCase.ecUpperCase;
      else
        FColumn.CellCharCase := TEditCharCase.ecNormal;
    end;
  end

  ;
  PageRefresh;

end;

procedure TfrmWizGridWiz.cmbLdLsChange(Sender: TObject);
begin
  case cmbLdLs.ItemIndex of
    0: cmbLookup.Hint := 'LookupData';
    1: cmbLookup.Hint := 'LookupSpecial';
  end;
  RefreshLookup;
end;

procedure TfrmWizGridWiz.cmbLineTypeChange(Sender: TObject);
var
  s: string;
begin
  s := copy(cmbLineType.Items[cmbLineType.ItemIndex], 1, 2);
  FGrid.Columns.LineType := BafGetGridLineType(s);
  FGrid.Columns.GridHeaderLineBreak;
  PageRefresh;
end;

procedure TfrmWizGridWiz.cmbNVChange(Sender: TObject);
begin
  edtNV.Visible := (cmbNV.ItemIndex > 0);
  btnGuid.Visible := (cmbNV.ItemIndex > 0);
  btnFnd.Visible := (cmbNV.ItemIndex > 0);
end;

procedure TfrmWizGridWiz.Column2Form(AColumn: TBafSgColumn);
var
  s: string;
begin
  FColLock := true;
  try
    FColumn := AColumn;
    edtCellFieldName.Text := AColumn.CellFieldName;
    edtCellHintFieldName.Text := AColumn.CellHintFieldName;
    cmbCellType.ItemIndex
        := cmbCellType.Items.IndexOf(BafGetCellTypeName(AColumn.CellType));
    cmbCellAlign.ItemIndex
        := cmbCellAlign.Items.IndexOf(BafGetAlignName(AColumn.CellAlignment));
    InitLookup;
    cbNoData.IsChecked := AColumn.CellNoData;
    cbReadOnly.IsChecked := AColumn.CellReadOnly;
    sbWidth.Value := AColumn.Width;
    sbWidthStretch.Value := AColumn.Stretch;
    sbLength.Value := AColumn.CellMaxLength;
    cmbNV.ItemIndex := integer(FColumn.CellNullValueAction);
    case FColumn.CellCharCase of
      TEditCharCase.ecLowerCase: cmbCharacterType.ItemIndex := 0;
      TEditCharCase.ecUpperCase: cmbCharacterType.ItemIndex := 2;
      else
        cmbCharacterType.ItemIndex := 1;
    end;
    edtNV.Text := FColumn.CellNullValue;
    HfValues;
  finally
    FColLock := false;
  end;
end;

procedure TfrmWizGridWiz.edtHfCaptionChange(Sender: TObject);
var
  s: string;
begin
  if FColLock or (FHfBafRow = nil) or (FColumn = nil) then
    exit;
  if Sender = edtHfCaption then
    FHfBafRow.Cells[FColumn.Index].Text := edtHfCaption.Text
  else if Sender = edtHfHint then
    FHfBafRow.Cells[FColumn.Index].Hint := edtHfHint.Text
  else if Sender = sbHfColSpan then
    FHfBafRow.Cells[FColumn.Index].ColSpan := round(sbHfColSpan.Value)

  else if Sender = cmbHfType then begin
    if cmbHfType.ItemIndex >= 0 then begin
      s := cmbHfType.Items[cmbHfType.ItemIndex];
      FHfBafRow.Cells[FColumn.Index].CellType := BafGetCellType(s);
    end
  end
  else if Sender = cmbHfAlign then begin
    if cmbHfAlign.ItemIndex >= 0 then begin
      s := cmbHfAlign.Items[cmbHfAlign.ItemIndex];
      FHfBafRow.Cells[FColumn.Index].Alignment := BafGetAlign(s, taLeftJustify);
    end
  end
  else if Sender = edtHfCmd then
    FHfBafRow.Cells[FColumn.Index].Command := edtHfCmd.Text
  ;
  PageRefresh;
end;

procedure TfrmWizGridWiz.FormCreate(Sender: TObject);
begin
  InitInterpreter;
end;

function TfrmWizGridWiz.GetCode: string;
var
  s, t: string;
  i, LCol: integer;
  LColumn: TBafSgColumn;
  LFooter: boolean;
  LHfRow: integer;
  LHfBafRow: TBafSgRow;
  LHfBafCell: TBafSgCell;
  sl: TStringList;

  procedure lokGridSeg;
  begin
    result := '#grd_seg   hrc=' + IntTostr(round(sbWizGridWizHeaderRowCount.Value));
    if round(sbWizGridWizFooterRowCount.Value) > 0 then
      result := result + '   frc=' + IntTostr(round(sbWizGridWizFooterRowCount.Value));
    if round(sbFixedColumnsCount.Value) > 0 then
      result := result + '   fcc=' + IntTostr(round(sbFixedColumnsCount.Value));
    result := result + '   clt=' + copy(cmbLineType.Items[cmbLineType.ItemIndex], 1, 2)
        + '   n=' + edtName.Text;
    if cbBtnActive.IsChecked then
      s := 'A';
    if cbBtnInactive.IsChecked then
      s := s + 'I';
    if cbBtnFilter.IsChecked then
      s := s + 'F';
    if cbBtnXls.IsChecked then
      s := s + 'X';
    if cbBtnPdf.IsChecked then
      s := s + 'Y';
    if cbBtnHistory.IsChecked then
      s := s + 'H';
    if edtCaption.Text <> '' then
      result := result + '   c="' + edtCaption.Text + '"'
    else if s <> '' then
      result := result + '   c=" "';
    if s <> '' then
      result := result + '   b=' + s;
    if cbGridReadOnly.IsChecked then
      result := result + '   ro=Y';
    result := result + #13#10;
  end; // procedure lokGridSeg

  procedure lokHeaderFooter(AIndex: integer);
  begin
    t := lbHf.Items[AIndex];
    LFooter := t[1] = 'f';
    LHfRow := StrToInt(t[2]);
    if LFooter then
      LHfBafRow := FGrid.Row[rtFooter, LHfRow - 1]
    else
      LHfBafRow := FGrid.Row[rtHeader, LHfRow - 1];
    LHfBafCell := LHfBafRow.Cells[LCol];
    if (LHfBafCell.Command = '') and (LHfBafCell.Text <> '') then
      s := s + '   ' + IfThen(LFooter, 'f', '') + 'c' + IntToStr(LHfRow)
          + '="' + LHfBafCell.Text + '"';
    if (LHfBafCell.Hint <> '') then
      s := s + '   ' + IfThen(LFooter, 'f', '') + 'h' + IntToStr(LHfRow)
          + '="' + LHfBafCell.Hint + '"';
    if LHfBafCell.ColSpan > 1 then
      s := s + '   ' + IfThen(LFooter, 'f', '') + 'cs' + IntToStr(LHfRow)
          + '=' + IntToStr(LHfBafCell.ColSpan) + '';
    if LHfBafCell.Alignment <> taLeftJustify then
      s := s + '   ' + IfThen(LFooter, 'f', '') + 'a' + IntToStr(LHfRow)
          + '=' + BafGetAlignName(LHfBafCell.Alignment) + '';
    if LFooter and (LHfBafCell.CellType <> ctText) then
      s := s + '   fy' + IntToStr(LHfRow)
          + '=' + BafGetCellTypeName(LHfBafCell.CellType) + '';
    if LFooter and (LHfBafCell.Command <> '') then
      s := s + '   fcmd' + IntToStr(LHfRow)
          + '="' + LHfBafCell.Command + '"';
  end; // procedure lokHeaderFooter

  procedure lokColumn;
  var
    i: integer;
  begin
    LColumn := lbColumns.Items.Objects[LCol] as TBafSgColumn;
    s := '#grd_col   f=' + LColumn.CellFieldName;
    if LColumn.CellHintFieldName <> '' then
      s := s + '   h=' + LColumn.CellHintFieldName;
    if LColumn.CellType <> ctText then
      s := s + '   y=' + BafGetCellTypeName(LColumn.CellType);
    if LColumn.CellType in [ctLookup, ctLookupText] then
      s := s + '   ' + LColumn.CellLookupCmd;
    if LColumn.CellMaxLength > 0 then
      s := s + '   l=' + IntToStr(LColumn.CellMaxLength);
    s := s + '   w=' + IntToStr(round(LColumn.Width));
    if LColumn.Stretch > 0.3 then
      s := s + '   wst=' + IntToStr(round(LColumn.Stretch));
    if LColumn.CellAlignment <> taLeftJustify then
      s := s + '   a=' + BafGetAlignName(LColumn.CellAlignment);
    if LColumn.CellNoData then
      s := s + '   nd=Y';
    if LColumn.CellReadOnly then
      s := s + '   ro=Y';
    if LColumn.CellCharsIgnore <> '' then
      s := s + '   ci="' + LColumn.CellCharsIgnore + '"';
    if LColumn.CellNullValueAction <> nvNone then
      s := s + '   ' + BafGetNvaName(LColumn.CellNullValueAction)
          + '=' + LColumn.CellNullValue;

    for i := 0 to lbHf.Count - 1 do
      lokHeaderFooter(i);

    result := result + s + #13#10;
  end; // procedure lokColumn

begin
  lokGridSeg;
  for LCol := 0 to lbColumns.Items.Count - 1 do
    lokColumn;

  sl := TStringList.Create;
  try
    sl.Text := FWizSql;
    for i := 0 to sl.Count - 1 do
      result := result + '#sql ' + sl[i] + #13#10;
  finally
    sl.Free;
  end;

  if FWizDB = 'default' then
    result := result + '#grd_data   q=sql   t=   ' + #13#10
  else
    result := result + '#grd_data   q=sql   db=' + FWizDB + '   t=   ' + #13#10;
// function TfrmWizGridWiz.GetCode
end;

class function TfrmWizGridWiz.GetGridCode(AGrid, AParams: TStringGrid;
    AWizSql, AWizDb, AGridSeg: string): string;
var
  LLine, LFn: string;
  i, LRow: integer;
  sl, sl2: TStringList;

  procedure lokCheckInsert(ACol: integer; APre, AAdd: string);
  begin
    if AGrid.Cells[ACol, LRow] <> '' then
      LLine := LLine + '   ' + APre + '=' + AGrid.Cells[ACol, LRow] + AAdd;
  end;

begin
  sl := TStringList.Create;
  try
    sl.Text := '#grd_seg   frc=0   fcc=1   clt=ss   n=grid   ' + AGridSeg;
    for LRow := 0 to AGrid.RowCount - 1 do begin
      if AGrid.Cells[0, LRow] = 'True' then begin
        LFn := AnsiLowerCase(AGrid.Cells[1, LRow]);
        if (LRow = 0) and (Copy(LFn, Length(LFn) - 2, 3) = '_id') then
          LLine := '#grd_col   f=' + LFn + '   c1=ID   w=30   y=guid   ro=Y'
        else begin
          LLine := '#grd_col   f=' + AGrid.Cells[1, LRow]
              + '   c1="' + AGrid.Cells[2, LRow] + '"';
          lokCheckInsert(3, 'w', '');
          lokCheckInsert(4, 'wst', '');
          lokCheckInsert(5, 'l', '');
          lokCheckInsert(6, 'y', '');
          lokCheckInsert(7, 'a', '   a1=l');
          if AGrid.Cells[8, LRow] = 'True' then
              LLine := LLine + '   ro=Y';
        end;
        sl.Add(LLine);
      end;
    end;

    sl2 := TStringList.Create;
    try
      sl2.Text := AWizSql;
      for i := 0 to sl2.Count - 1 do
        sl.Add('#sql ' + sl2[i]);
    finally
      sl2.Free;
    end;

    if AWizDb = 'default' then
      LLine := '#grd_data   q=sql   t=   '
    else
      LLine := '#grd_data   q=sql   db=' + AWizDb + '   t=   ';
    for LRow := 0 to AParams.RowCount - 1 do
      LLine := LLine + AParams.Cells[0, LRow] + '=' + AParams.Cells[1, LRow] + '   ';
    sl.Add(LLine);
  finally
    result := sl.Text;
    sl.Free;
  end;
// class function TfrmWizGridWiz.GetGridCode
end;

procedure TfrmWizGridWiz.HfValues;
begin
  if (FHfBafRow = nil) or (FColumn = nil) then
    exit;
  try
    if Trim(FHfBafRow.Cells[FColumn.Index].Command) = '' then
      edtHfCaption.Text := FHfBafRow.Cells[FColumn.Index].Text;
    edtHfHint.Text := FHfBafRow.Cells[FColumn.Index].Hint;
    sbHfColSpan.Value := FHfBafRow.Cells[FColumn.Index].ColSpan;
    cmbHfType.ItemIndex
        := cmbHfType.Items.IndexOf(BafGetCellTypeName(FHfBafRow.Cells[FColumn.Index].CellType));
    cmbHfAlign.ItemIndex
        := cmbHfAlign.Items.IndexOf(BafGetAlignName(FHfBafRow.Cells[FColumn.Index].Alignment));
    edtHfCmd.Text := FHfBafRow.Cells[FColumn.Index].Command;
  except

  end;
end;

procedure TfrmWizGridWiz.Init(AGrid, AParams: TStringGrid; AWizSql, AWizDb: string);
var
  LCode: string;
  LComp: TComponent;
begin
  FWizSql := AWizSql;
  FWizDB := AWizDb;
  LCode := '#rights  n=frm   r_user=w' + #13#10
     + '#frm  y=page ' + #13#10
     + '#page   y=dashhor' + #13#10
     + '#prim  as=Y' + #13#10
     + '#cat  as=Y      c=Preview' + #13#10
     + GetGridCode(AGrid, AParams, AWizSql, AWizDb, 'aso=Y') + #13#10
     + '#page_ready' + #13#10;
  FInter.Execute(LCode);
  LComp := FInter.GetFrmComponent('page');
  TBafPage(LComp).OnSelectCell := PageSelectCell;
  TBafPage(LComp).OnResizeCell := PageResizeCell;
  FGrid := nil;
  if Assigned(LComp) and (LComp is TBafPage) then
    FGrid := TBafPage(LComp).PrimaryDivs.Items[0].Categories.Items[0].Segments.Items[0].Grid;
  sbWizGridWizHeaderRowCount.Value := 1;
  sbWizGridWizFooterRowCount.Value := 0;
  sbWizGirdWizHeaderRow.Value := 1;
  sbFixedColumnsCount.Value := 1;
  cmbLineType.ItemIndex := 1;
  edtName.Text := 'grid';
  tcWizGridWiz.ActiveTab := tabGrid;
  tabColumnClick(nil);
  RefreshColumns;
end;

procedure TfrmWizGridWiz.InitInterpreter;
begin
  FInter := TBafInterpreter.Create(itClient);
  FInter.Inter := FInter;
  FInter.Name := 'WizGridWiz';
  FInter.OnNeedCommand := InterNeedCommand;
  FInter.OnNeedInfo := InterNeedInfo;
//  FInter.OnLog := InterLog;
  FInter.ParentPanel := pnlGrid;
  TBafInterpreterModuleList.CreateModule(FInter);
end;

procedure TfrmWizGridWiz.InitLookup;
var
  s: string;
  p: integer;
begin
  cmbLdLs.Visible := FColumn.CellType in [ctLookup, ctLookupText];
  cmbLookup.Visible := FColumn.CellType in [ctLookup, ctLookupText];
  lblLength.Visible := not (FColumn.CellType in [ctLookup, ctLookupText]);
  sbLength.Visible := not (FColumn.CellType in [ctLookup, ctLookupText]);
  if FColumn.CellType in [ctLookup, ctLookupText] then begin
    s := FColumn.CellLookupCmd;
    p := Pos('=', s);
    if copy(s, 1, p - 1) = 'ls' then
      cmbLdLs.ItemIndex := 1
    else
      cmbLdLs.ItemIndex := 0;
    RefreshLookup;
    s := copy(s, p + 1, MaxInt);
    FHelper.SetGuid(cmbLookup, s);
  end;
end;

procedure TfrmWizGridWiz.InterNeedCommand(AInter: TBafInterpreter;
  AName: string; ACode: TStrings);
begin
  AName := AnsiLowerCase(AName);
  if not dataMain.GetCommand(AName, ACode) then
//    InterLog(nil, 'E', 'Kommando nicht gefunden: ' + AName);
end;

procedure TfrmWizGridWiz.InterNeedInfo(AInter: TBafInterpreter; AName,
  AParam: string; var AInfo: string);
begin
  AName := AnsiLowerCase(AName);
  if AName = 'usrid' then AInfo := dataMain.UserGuid
  else if AName = 'rightusrid' then AInfo := dataMain.RightUserId
  else if AName = 'root' then AInfo := dataMain.Root
  else if AName = 'usrroot' then AInfo := dataMain.UserRoot
  else if AName = 'usrini' then AInfo := dataMain.UserIni.ReadString(CAT_USRDATA, AParam, '')
  else if AName = 'ini' then AInfo := dataMain.Ini.ReadString(CAT_DATA, AParam, '')
  ;
end;

procedure TfrmWizGridWiz.lbColumnsChange(Sender: TObject);
begin
  if lbColumns.ItemIndex >= 0 then
    Column2Form(lbColumns.Items.Objects[lbColumns.ItemIndex] as TBafSgColumn);
end;

procedure TfrmWizGridWiz.lbHfChange(Sender: TObject);
var
  s: string;
begin
  FColLock := true;
  try
    s := lbHf.Items[lbHf.ItemIndex];
    FFooter := (s[1] = 'f');
    FHfRow := StrToInt(s[2]);
    if FFooter then
      FHfBafRow := FGrid.Row[rtFooter, FHfRow - 1]
    else
      FHfBafRow := FGrid.Row[rtHeader, FHfRow - 1];
    lblHfCaption.Text := IfThen(FFooter, 'f') + 'c' + IntToStr(FHfRow);
    lblHfHint.Text := IfThen(FFooter, 'f') + 'h' + IntToStr(FHfRow);
    lblHfColSpan.Text := IfThen(FFooter, 'f') + 'cs' + IntToStr(FHfRow);
    lblHfAlign.Text := IfThen(FFooter, 'f') + 'a' + IntToStr(FHfRow);
    lblHfType.Text := 'fy' + IntToStr(FHfRow);
    lblHfCmd.Text := 'fcmd' + IntToStr(FHfRow);
    lblHfType.Visible := FFooter;
    cmbHfType.Visible := FFooter;
    lblHfCmd.Visible := FFooter;
    edtHfCmd.Visible := FFooter;
    btnHfCount.Visible := FFooter;
    btnHfSum.Visible := FFooter;
    btnHfMin.Visible := FFooter;
    btnHfMax.Visible := FFooter;
    btnHfAvg.Visible := FFooter;
    btnHfMed.Visible := FFooter;
    HfValues;
  finally
    FColLock := false;
  end;
end;

procedure TfrmWizGridWiz.PageRefresh;
var
  LPage: TBafPage;
begin
  LPage := FGrid.Parents.Page;
  LPage.SetAutoSize;
  LPage.RecalcCells;
  LPage.Resize;
end;

procedure TfrmWizGridWiz.PageResizeCell(const Sender: TBafPageParents);
begin
  if Assigned(FColumn)
      and (Sender.Column.Index <> FColumn.Index)
      and (Sender.Column.Index >= 0) then
    lbColumns.ItemIndex := Sender.Column.Index;
  FColLock := true;
  try
    sbWidth.Value := round(Sender.Column.Width);
    sbWidthStretch.Value := 0;
  finally
    FColLock := false;
  end;
  PageRefresh;
end;

procedure TfrmWizGridWiz.PageSelectCell(const Sender: TBafPageParents);
begin
  if Assigned(FColumn)
      and (Sender.Column.Index <> FColumn.Index)
      and (Sender.Column.Index >= 0) then
    lbColumns.ItemIndex := Sender.Column.Index;
end;

procedure TfrmWizGridWiz.RefreshColumns;
var
  LCol: integer;
  LColumn: TBafSgColumn;
begin
  lbColumns.Clear;
  for LCol := 0 to FGrid.Columns.Count - 1 do begin
    LColumn := FGrid.Columns.Items[LCol];
    lbColumns.Items.AddObject(Format('[%d] %s', [round(LColumn.Width),
        LColumn.CellFieldName]), LColumn);
  end;
  if lbColumns.Items.Count > 0 then
    lbColumns.ItemIndex := 0;
end;

procedure TfrmWizGridWiz.RefreshLookup;
begin
  case cmbLdLs.ItemIndex of
    0: FHelper := gvBafDataCache.Special['system_lookup_lists'];
    1: FHelper := gvBafDataCache.Special['system_special_lists'];
  end;
  FHelper.FillComboBox(cmbLookup);
end;

procedure TfrmWizGridWiz.sbWizGridWizHeaderRowCountChange(Sender: TObject);
var
  AList: TObjectList;
  i: integer;
begin
  if FGrid = nil then
    exit;
  if Sender = sbWizGridWizHeaderRowCount then begin
    i := round(sbWizGridWizHeaderRowCount.Value);
    FGrid.SetRowCount(rtHeader, i);
    if i > 0 then
      sbWizGirdWizHeaderRow.Max := i;
  end
  else if Sender = sbWizGridWizFooterRowCount then
    FGrid.SetRowCount(rtFooter, round(sbWizGridWizFooterRowCount.Value));
  PageRefresh;
end;

procedure TfrmWizGridWiz.tabCodeClick(Sender: TObject);
begin
  memWizGridWizCode.Lines.Text := GetCode;
  Clipboard.AsText := memWizGridWizCode.Lines.Text;
end;

procedure TfrmWizGridWiz.tabColumnClick(Sender: TObject);
var
  i: integer;
begin
  lbHf.Clear;
  for i := 1 to round(sbWizGridWizHeaderRowCount.Value) do
    lbHf.Items.Add('h' + IntToStr(i));
  for i := 1 to round(sbWizGridWizFooterRowCount.Value) do
    lbHf.Items.Add('f' + IntToStr(i));
  if lbHf.Items.Count > 0 then
    lbHf.ItemIndex := 0;
end;

end.
